// src/pages/Home.jsx
import React, { useState, useEffect } from 'react';
import { getActivityPreviews, getFullActivities } from '../api/activity';
import Post from '../components/Post';
import Navbar from '../components/Navbar'; // ✅ 导入导航栏组件
import { AppstoreOutlined } from '@ant-design/icons';
import { Row, Col, Card, Space } from 'antd';
import './Home.css';

const Community = () => {
    const [activityPreviews, setActivityPreviews] = useState([]);
    const [fullActivities, setFullActivities] = useState([]);
    const [selectedActivityId, setSelectedActivityId] = useState(null);

    useEffect(() => {
        getActivityPreviews().then(res => setActivityPreviews(res.data));
        getFullActivities().then(res => setFullActivities(res.data));
    }, []);

    return (
        <div style={{ minHeight: '100vh', backgroundColor: '#f0f2f5' }}>
            {/* 导航栏 */}
            <Navbar />

            {/* 内容区域 */}
            <div style={{ padding: 24 }}>
                {/* 帖子区域 */}
                <Row justify="center">
                    <Col
                        xs={24}
                        sm={24}
                        md={24}
                        lg={22}
                        xl={20}
                        xxl={18}
                        style={{ maxWidth: 1400, width: '100%' }}
                    >
                        <Card
                            title={<Space><AppstoreOutlined />最新帖子</Space>}
                            bordered={false}
                            bodyStyle={{ padding: 24 }}
                            style={{ boxShadow: '0 2px 8px rgba(0,0,0,0.15)', borderRadius: 8 }}
                        >
                            <Post />
                        </Card>
                    </Col>
                </Row>
            </div>
        </div>
    );
};

export default Community;
