import React, { useEffect, useState } from 'react';
import ReactMarkdown from 'react-markdown';
import remarkGfm from 'remark-gfm';
import rehypeHighlight from 'rehype-highlight';
import './HelpPage.css'; // 引入样式
import Navbar from '../components/Navbar'; // 导航栏组件

export default function HelpPage() {
  const [markdown, setMarkdown] = useState('');

  useEffect(() => {
    fetch('/help.md')
      .then(res => {
        if (!res.ok) throw new Error('Markdown 文件加载失败');
        return res.text();
      })
      .then(text => setMarkdown(text))
      .catch(() => setMarkdown('# 帮助文档加载失败，请稍后再试。'));
  }, []);

   return (
     <div>
      <Navbar />
      <div className="help-page-wrapper">
        <div className="help-container">
          <h1 className="help-title">📚 帮助文档</h1>
          <div className="help-content">
            <ReactMarkdown
              remarkPlugins={[remarkGfm]}
              rehypePlugins={[rehypeHighlight]}
              components={{
                h1: ({ node, ...props }) => <h1 {...props} />,
                h2: ({ node, ...props }) => <h2 {...props} />,
                p: ({ node, ...props }) => <p {...props} />,
                code: ({ node, ...props }) => <code {...props} />,
                pre: ({ node, ...props }) => <pre {...props} />,
                blockquote: ({ node, ...props }) => <blockquote {...props} />,
              }}
            >
              {markdown}
            </ReactMarkdown>
          </div>
        </div>
      </div>
    </div>
  );
}
