// pages/Home.js
import React, { useState, useEffect } from 'react';
import { getActivityPreviews, getFullActivities } from '../api/activity';
import RecommendAll from '../components/RecommendAll'; // 假设你有一个推荐预览组件
import RecommendPreview from '../components/RecommendPreview';
import Navbar from '../components/Navbar'; // 导航栏组件

const Home = () => {
  const [activityPreviews, setActivityPreviews] = useState([]);
  const [fullActivities, setFullActivities] = useState([]);
  const [selectedActivityId, setSelectedActivityId] = useState(null);

  useEffect(() => {
    getActivityPreviews().then(res => setActivityPreviews(res.data));
    getFullActivities().then(res => setFullActivities(res.data));
  }, []);

  const selectedActivity = fullActivities.find(
    activity => activity.activityid === selectedActivityId
  );

  return (
    <div>
      <Navbar className="fixed top-0 left-0 w-full z-50" /> {/* 导航栏组件 */}
      <h1 className="text-3xl font-bold text-center mb-4">社交互动平台 - 首页</h1>
      
      {/* 活动区域 */}
      <div className="bg-white p-4 rounded shadow mb-8">
        <h2 className="text-xl font-semibold mb-4">活动预览</h2>
        {!selectedActivity ? (
          <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
            {activityPreviews.map(activity => (
              <div key={activity.activityid} className="border p-3 rounded shadow">
                <h3 className="text-lg font-medium mb-2">{activity.title}</h3>
                <img
                  src={activity.photo}
                  alt={activity.title}
                  className="w-full h-40 object-cover mb-2 rounded"
                />
                <button
                  className="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600"
                  onClick={() => setSelectedActivityId(activity.activityid)}
                >
                  查看详情
                </button>
              </div>
            ))}
          </div>
        ) : (
          <div className="p-4 border rounded shadow">
            <button
              className="mb-4 text-blue-600 underline"
              onClick={() => setSelectedActivityId(null)}
            >
              ← 返回列表
            </button>
            <h3 className="text-2xl font-bold mb-2">{selectedActivity.title}</h3>
            <img
              src={selectedActivity.photo}
              alt={selectedActivity.title}
              className="w-full h-60 object-cover rounded mb-4"
            />
            <p className="mb-2"><strong>内容：</strong>{selectedActivity.content}</p>
            <p className="mb-2"><strong>时间：</strong>{selectedActivity.time}</p>
            <p className="mb-2"><strong>奖励：</strong>{selectedActivity.award}</p>
          </div>
        )}
      </div>
       <RecommendPreview />
    </div>
  );
};

export default Home;