// src/pages/MainPage.jsx
import React from 'react';
import { useNavigate } from 'react-router-dom';
import Navbar from '../components/Navbar';
import ActivityBoard from '../components/ActivityBoard';
import './MainPage.css';
import RecommendPreview from'../components/RecommendPreview'; // 引入推荐预览样式

const MainPage = () => {
    const navigate = useNavigate();
    const currentUser = {
        id: 2,
        username: '测试用户',
    };

    return (
        <div className="main-page-wrapper">
            {/* 顶部导航栏 */}
            <Navbar />

            <main className="main-page-content">

                {/* 公告区域 */}
                <section className="card-section">
                    <ActivityBoard />
                </section>

                {/* 推荐下载资源预留区域 */}
                <section className="card-section">
                    {/* <h2 className="section-title">📥 推荐下载资源</h2>
                    <div className="placeholder-box"> */}
                        {/* <p className="placeholder-text">这里将展示为你推荐的种子资源，敬请期待～</p> */}
                        <RecommendPreview/>
                    {/* </div> */}
                </section>
            </main>
        </div>
    );
};

export default MainPage;
