import React from 'react';
import { render, screen, waitFor } from '@testing-library/react';
import { MemoryRouter, Route, Routes } from 'react-router-dom';
import axios from 'axios';
import TorrentDetail from '../components/Torrentdetail';
import { vi } from 'vitest';


beforeAll(() => {
  Object.defineProperty(window, 'matchMedia', {
    writable: true,
    value: vi.fn().mockImplementation((query) => ({
      matches: false,
      media: query,
      onchange: null,
      addListener: vi.fn(),
      removeListener: vi.fn(),
      addEventListener: vi.fn(),
      removeEventListener: vi.fn(),
      dispatchEvent: vi.fn(),
    })),
  });
});


// 模拟 axios
vi.mock('axios');

describe('TorrentDetail Page', () => {
  const mockTorrent = {
    torrentTitle: '测试种子',
    uploader_id: 'uploader123',
    description: '这是一个测试种子描述',
    uploadTime: '2024-06-01T12:00:00Z',
    torrentSize: 104857600,
    downloadCount: 10,
    dpi: '1080p',
    caption: '简体中文',
    lastseed: '2024-06-05T14:00:00Z',
    coverImagePath: 'http://example.com/cover.jpg',
    infoHash: 'abc123'
  };

  const mockSeeders = [
    {
      username: 'Seeder1',
      uploaded: 204857600,
      uploadSpeed: 1048576,
      downloaded: 102400,
      downloadSpeed: 0,
      client: 'qBittorrent',
      lastEvent: '2024-06-06T11:22:00Z'
    }
  ];

  beforeEach(() => {
    axios.get.mockImplementation((url) => {
      if (url.includes('/torrent/abc123/seeders')) {
        return Promise.resolve({ data: mockSeeders });
      }
      if (url.includes('/torrent/123')) {
        return Promise.resolve({ data: mockTorrent });
      }
      return Promise.reject(new Error('not found'));
    });
  });

  afterEach(() => {
    vi.clearAllMocks();
  });

  test('renders torrent detail and seeders correctly', async () => {
    render(
      <MemoryRouter initialEntries={['/torrent/123']}>
        <Routes>
          <Route path="/torrent/:id" element={<TorrentDetail />} />
        </Routes>
      </MemoryRouter>
    );

    expect(document.querySelector('.ant-spin')).toBeInTheDocument();


    await waitFor(() => {
      expect(screen.getByText('测试种子')).toBeInTheDocument();
      expect(screen.getByText('uploader123')).toBeInTheDocument();
      expect(screen.getByText(/1080p/)).toBeInTheDocument();
      expect(screen.getByText('Seeder1')).toBeInTheDocument();
    });
  });
});
