import React from 'react';
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import Home from './pages/Home';
import AdminPage from './pages/AdminPage';
import TorrentDetail from './components/torrentdetail';
import TorrentDetailhelp from './components/torrentdetailhelp';
import TorrentDetailcomplain from './components/torrentdetailcomplain';
import TorrentList from './components/torrentlist';
import UploadTorrent from './components/upload';
import Navbar from './components/Navbar';
import TorrentDetailmanage from './pages/managetorrentdetail';
import RecommendAll from './components/RecommendAll';
import UserAuth from './pages/UserAuth';
import 'antd/dist/reset.css'; // Ant Design 默认样式
import './App.css';
import MainPage from './pages/MainPage';
import Friend from './pages/Friend';
import Community from './pages/Community';
import UserCenter from './pages/UserCenter111';
import UploadTorrentFull from './components/upload-full';
import ShopPage from './pages/ShopPage';

// 定义橙色主题（使用 Ant Design 的 orange-6 色值）
const orangeTheme = {
  token: {
    colorPrimary: '#fa8c16', // orange-6
    borderRadius: 4,         // 可选：圆角大小
  },
};

function App() {
  return (
    <div className="App">
      {/* <div className="container mx-auto p-4"> */}
        <Routes>
          {/* <Route path="/" element={<Home />} /> */}
          <Route path="/home" element={<MainPage />} />
          <Route path="/admin" element={<AdminPage />} />
          <Route path="/admin/:id" element={<TorrentDetailmanage />} />
          <Route path="/process/:id" element={<TorrentDetailhelp />} />
          <Route path="/complain-process/:id" element={<TorrentDetailcomplain />} />
          <Route path="/torrents" element={<TorrentList />} />
          <Route path="/upload" element={<UploadTorrent />} />
          <Route path="/torrent/:id" element={<TorrentDetail />} />
          <Route path="/recommend" element={<RecommendAll />} />
          <Route path="/" element={<UserAuth />} />
          <Route path="/Community" element={<Community />} />
          <Route path="/friend" element={<Friend />} />
          <Route path="/usercenter" element={<UserCenter />} />
          <Route path="/uploadfull/:requestid" element={<UploadTorrentFull/>}/>
          <Route path="/shop" element={<ShopPage />} />
        </Routes>
      {/* </div> */}
    </div>
  );
}

export default App;