import axios from 'axios';

const BASE_URL = 'http://localhost:8080/comment';

// 创建评论
export const createComment = (commentData) => {
    return axios.post(`${BASE_URL}/create`, commentData);
};

// 删除评论
export const deleteComment = (commentId) => {
    return axios.delete(`${BASE_URL}/delete/${commentId}`);
};

// 更新评论
export const updateComment = (commentData) => {
    return axios.put(`${BASE_URL}/update`, commentData);
};

// 获取某个帖子的所有评论
// comment.js
export async function getCommentsByPostId(postid) {
    try {
        const response = await axios.get(`${BASE_URL}/post/${postid}`);
        return Array.isArray(response.data) ? response.data : []; // 确保返回数据是数组
    } catch (error) {
        console.error('获取评论失败', error);
        return [];
    }
}

// 点赞评论
export const likeComment = (commentId) => {
    return axios.post(`${BASE_URL}/like/${commentId}`);
};

// 取消点赞评论
export const unlikeComment = (commentId) => {
    return axios.post(`${BASE_URL}/unlike/${commentId}`);
};
