import React, { useEffect, useState } from 'react';
import { useNavigate } from 'react-router-dom';
import '../RecommendPreview.css';

const RecommendPreview = () => {
  
  const [recommendList, setRecommendList] = useState([]);
  const navigate = useNavigate();

  const storedUser = localStorage.getItem('user');
    //let currentUserId = null; // 初始化为 null
    let currentUserId = null; // 初始化为 null

    if (storedUser) {
        try {
            const parsedUser = JSON.parse(storedUser);
            currentUserId = parsedUser.userid; // 直接赋值
        } catch (error) {
            console.error('解析用户数据失败:', error);
            // 可以在这里处理 JSON 解析错误（如数据损坏）
        }
    } else {
        console.log('用户未登录');
    }

    // 现在 currentUserId 可以在后续逻辑中使用
    console.log('当前用户ID:', currentUserId);

  useEffect(() => {
    const fetchRecommendList = async () => {
      try {
        const res = await fetch(`http://localhost:8080/recommend/list?userId=${currentUserId}`);
        //const res = await fetch('http://localhost:8080/torrent/list');
        const data = await res.json();
        console.log('推荐列表数据:', data);
        setRecommendList(data.slice(0, 8)); // 只展示前8个
      } catch (err) {
        console.error('推荐获取失败:', err);
      }
    };
    fetchRecommendList();
  }, []);

  const formatFileSize = (bytes) => {
    if (!bytes) return '0 Bytes';
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(1024));
    return (bytes / Math.pow(1024, i)).toFixed(2) + ' ' + sizes[i];
  };

  const formatDate = (dateString) => {
    const date = new Date(dateString);
    return date.toLocaleDateString();
  };

  return (
    <div className="recommend-horizontal-container">
      <div className="recommend-header">
        <h2>为你推荐</h2>
        <button className="more-btn" onClick={() => navigate('/recommend')}>
          更多
        </button>
      </div>

      <div className="recommend-horizontal-grid">
        {recommendList.map((torrent) => (
          <div key={torrent.torrentid} className="horizontal-card">
            {torrent.coverImagePath ? (
              <img src={torrent.coverImagePath} alt="封面" className="card-cover" />
            ) : (
              <div className="card-no-cover">无封面</div>
            )}
            <div className="card-info">
              <div className="card-title" title={torrent.torrentTitle || torrent.filename}>
                {torrent.torrentTitle || torrent.filename}
              </div>
              <div className="card-description">
                {torrent.description || '暂无描述'}
              </div>
              <div className="card-meta">
                <span>{formatDate(torrent.uploadTime)}</span>
                <span>{formatFileSize(torrent.torrentSize)}</span>
              </div>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
};

export default RecommendPreview;
