import React, { useState, useEffect } from 'react';
import axios from 'axios';
import "../upload.css";
import "../uploadtorrent.css";
import { Form, Input, Select, Button, Typography, Space, message,Switch } from 'antd';
import { useParams, useNavigate, useLocation, useSearchParams } from 'react-router-dom'; // 添加 useLocation
import { InboxOutlined } from '@ant-design/icons';
const { TextArea } = Input;
const { Text } = Typography;


function UploadTorrentFull() {
  const [userid,setuserid] = useState(1);
  const [title, setTitle] = useState('');
  const [description, setDescription] = useState('');
  const [categoryId, setCategoryId] = useState('');
  const [file, setFile] = useState(null);
  const [categories, setCategories] = useState([]);
  const [showSuccess, setShowSuccess] = useState(false);
  const [form] = Form.useForm();
  const location = useLocation(); // 添加这行获取location对象
    // 在组件状态中添加
    // 获取参数并设置默认值
    //const [manageId, setManageId] = useState(parseInt(searchParams.get('manageid')) || 1);
   // 正确从location.state获取参数
    const {requestid} = location.state || {};
  
  // 通用参数
  const [dpi, setDpi] = useState('');
  const [caption, setCaption] = useState('');
  const [region, setRegion] = useState('');
  const [year, setYear] = useState('');
  const [genre, setGenre] = useState('');
  const [format, setFormat] = useState('');
  const [resolution, setResolution] = useState('');
  const [coverImage, setCoverImage] = useState(null);
  
  // 特殊参数
  const [codecFormat, setCodecFormat] = useState('');
  const [platform, setPlatform] = useState('');
  const [language, setLanguage] = useState('');
  const [eventType, setEventType] = useState('');
  const [source, setSource] = useState('');
  const [style, setStyle] = useState('');
  const [dataType, setdataType] = useState('');
  const [isMainland, setIsMainland] = useState(false);

  // 根据分类显示不同的表单字段
  const [showMovieFields, setShowMovieFields] = useState(false);
  const [showMusicFields, setShowMusicFields] = useState(false);
  const [showGameFields, setShowGameFields] = useState(false);
  const [showTvFields, setShowTvFields] = useState(false);
  const [showAnimeFields, setShowAnimeFields] = useState(false);
  const [showlearningFields, setShowlearningFields] = useState(false);
  const [showsoftwareFields, setShowsoftwareFields] = useState(false);
  const [showvarietyFields, setShowvarietyFields] = useState(false);
  const [showsportsFields, setShowsportsFields] = useState(false);
  const [showdocFields, setShowdocFields] = useState(false);
  const [showotherFields, setShowotherFields] = useState(false);
  // 其他分类字段...
  // 编码格式选项
  const codecFormats = [
    { value: 'H.264', label: 'H.264' },
    { value: 'H.265', label: 'H.265' },
    { value: 'AV1', label: 'AV1' },
    { value: 'VP9', label: 'VP9' },
    { value: 'VC1', label: 'VC1' },
    { value: 'X264', label: 'X264' },
  ];
  const regions = [
    { value: '大陆', label: '大陆' },
    { value: '港台', label: '港台' },
    { value: '欧美', label: '欧美' },
    { value: '日韩', label: '日韩' },
    { value: '其他', label: '其他' },
  ];
  const genres = [
    { value: '动作', label: '动作' },
    { value: '喜剧', label: '喜剧' },
    { value: '爱情', label: '爱情' },
    { value: '科幻', label: '科幻' },
    { value: '恐怖', label: '恐怖' },
    { value: '动作', label: '动作' },
    { value: '冒险', label: '冒险' },
    { value: '历史', label: '历史' },
    { value: '悬疑', label: '悬疑' },
    { value: '其他', label: '其他' },
  ];
  const resolutions = [
    { value: '720p', label: '720p' },
    { value: '1080p', label: '1080p' },
    { value: '2K', label: '2K' },
    { value: '4K', label: '4K' },
    { value: '8K', label: '8K' },
    { value: '其他', label: '其他' },
  ];


  const eventTypes = [
    { value: '足球', label: '足球' },
    { value: '篮球', label: '篮球' },
    { value: '网球', label: '网球' },
    { value: '乒乓球', label: '乒乓球' },
    { value: '羽毛球', label: '羽毛球' },
  ]
  const styles = [
    { value: '大陆综艺', label: '大陆综艺' },
    { value: '日韩综艺', label: '日韩综艺' },
    { value: '欧美综艺', label: '欧美综艺' },
    { value: '其他', label: '其他' },
  ]
  const platforms = [
    { value: 'PC', label: 'PC' },
    { value: 'PS5', label: 'PS5' },
    { value: 'Xbox', label: 'Xbox' },
    { value: 'Switch', label: 'Switch' },
    { value: '手机', label: '手机' },
    { value: '其他', label: '其他' },
  ]
  const gamegenres = [
    { value: '角色扮演', label: '角色扮演' },
    { value: '射击', label: '射击' },
    { value: '冒险', label: '冒险' },
    { value: '策略', label: '策略' },
    { value: '体育', label: '体育' },
    { value: '桌面游戏', label: '桌面游戏'},
    { value: '其他', label: '其他' },
  ]
  const dataTypes = [
    { value: '压缩包', label: '压缩包' },
    { value: '补丁', label: '补丁' },
    { value: '安装包', label: '安装包' },
    { value: 'nds', label: 'nds' },
    { value: '其他', label: '其他' },
  ]
  const languages = [
    { value: '中文', label: '中文' },
    { value: '英文', label: '英文' },
    { value: '日文', label: '日文' },
    { value: '其他', label: '其他' },
  ]
  const musicgenres = [
    { value: '专辑', label: '专辑' },
    { value: '单曲', label: '单曲' },
    { value: 'EP', label: 'EP' },
    { value: '现场', label: '现场' },
    { value: '其他', label: '其他' },
  ]
  const musicstyles = [
    { value: '流行', label: '流行' },
    { value: '摇滚', label: '摇滚' },
    { value: '电子', label: '电子' },
    { value: '古典', label: '古典' },
    { value: '爵士', label: '爵士' },
    { value: '民谣', label: '民谣' },
    { value: '说唱', label: '说唱' },
    { value: '其他', label: '其他' },
  ]
  const musicformats = [
    { value: 'MP3', label: 'MP3' },
    { value: 'FLAC', label: 'FLAC' },
    { value: 'WAV', label: 'WAV' },
    { value: 'AAC', label: 'AAC' },
    { value: 'OGG', label: 'OGG' },
    { value: '其他', label: '其他' },
  ]
  const anigenres = [
    { value: '新番连载', label: '新番连载' },
    { value: '剧场版', label: '剧场版' },
    { value: 'OVA', label: 'OVA' },
    { value: '完结动漫', label: '完结动漫' },
    { value: '其他', label: '其他' },
  ]
  const animeformats = [
    { value: 'ZIP', label: 'ZIP' },
    { value: 'RAR', label: 'RAR' },
    { value: '7Z', label: '7Z' },
    { value: 'MKV', label: 'MKV' },
    { value: 'MP4', label: 'MP4' },
    { value: '其他', label: '其他' },
  ]
  const varietygenres = [
    { value: '真人秀', label: '真人秀' },
    { value: '选秀', label: '选秀' },
    { value: '访谈', label: '访谈' },
    { value: '游戏', label: '游戏' },
    { value: '音乐', label: '音乐' },
    { value: '其他', label: '其他' },
  ]
  const sportsgenres = [
    { value: '足球', label: '足球' },
    { value: '篮球', label: '篮球' },
    { value: '网球', label: '网球' },
    { value: '乒乓球', label: '乒乓球' },
    { value: '羽毛球', label: '羽毛球' },
    { value: '其他', label: '其他' },
  ]
  const softwaregenres = [
    { value: '系统软件', label: '系统软件' },
    { value: '应用软件', label: '应用软件' },
    { value: '游戏软件', label: '游戏软件' },
    { value: '驱动程序', label: '驱动程序' },
    { value: '办公软件', label: '办公软件' },
    { value: '其他', label: '其他' },
  ]
  const softwareplatforms = [
    { value: 'Windows', label: 'Windows' },
    { value: 'Mac', label: 'Mac' },
    { value: 'Linux', label: 'Linux' },
    { value: 'Android', label: 'Android' },
    { value: 'iOS', label: 'iOS' },
    { value: '其他', label: '其他' },
  ]
  const softwareformats = [
    { value: 'EXE', label: 'EXE' }, 
    { value: 'DMG', label: 'DMG' },
    { value: '光盘镜像', label: '光盘镜像' },
    { value: 'APK', label: 'APK' },
    { value: 'IPA', label: 'IPA' },
    { value: '其他', label: '其他' },
  ]
  const learninggenres = [
    { value: '计算机', label: '计算机' },
    { value: '软件', label: '软件' },
    { value: '人文', label: '人文' },
    { value: '外语', label: '外语' },
    { value: '理工类', label: '理工类' },
    { value: '其他', label: '其他' },
  ]
  const learningformats = [
    { value: 'PDF', label: 'PDF' },
    { value: 'EPUB', label: 'EPUB' },
    { value: '视频', label: '视频' },
    { value: '音频', label: '音频' },
    { value: 'PPT', label: 'PPT' },
    { value: '其他', label: '其他' },
  ]
  const sourceTypes = [
    { value: 'CCTV', label: 'CCTV' },
    { value: '卫视', label: '卫视' },
    { value: '国家地理', label: '国家地理' },
    { value: 'BBC', label: 'BBC' },
    { value: 'Discovery', label: 'Discovery' },
    { value: '其他', label: '其他' },
  ]
  const othergenres = [
    { value: '电子书', label: '电子书' },
    { value: '视频', label: '视频' },
    { value: 'MP3', label: 'MP3' },
    { value: '图片', label: '图片' },
    { value: '其他', label: '其他' },
  ]
  useEffect(() => {
    axios.get('http://localhost:8080/categories')
      .then(res => setCategories(res.data))
      .catch(err => console.error('加载分类失败', err));
  }, []);

  // 根据选择的分类显示不同的表单字段
  useEffect(() => {
    setShowMovieFields(categoryId === '1');
    setShowMusicFields(categoryId === '3');
    setShowGameFields(categoryId === '5');
    setShowTvFields(categoryId === '2');
    setShowAnimeFields(categoryId === '4');
    setShowlearningFields(categoryId === '9');
    setShowsoftwareFields(categoryId === '8');
    setShowvarietyFields(categoryId === '6');
    setShowsportsFields(categoryId === '7');
    setShowdocFields(categoryId === '10');
    setShowotherFields(categoryId === '11');
    // 其他分类...
  }, [categoryId]);

  
  const handleSubmit = async (e) => {
    //e.preventDefault();
    if (!coverImage) {
      alert('请选择一个 图片 文件');
      return;
    }
    if (!file) {
      alert('请选择一个 .torrent 文件');
      return;
    }

    if (!categoryId) {
      alert('请选择分类');
      return;
    }
    

    const formData = new FormData();
    formData.append('userid', userid);
    formData.append('file', file);
    // Add cover image if it exists
    formData.append('coverImage', coverImage);
    formData.append('title', title);
    formData.append('description', description);
    formData.append('categoryId', categoryId);
    formData.append('requestId', requestid);

    
    // 通用参数
    if (dpi) formData.append('dpi', dpi);
    if (caption) formData.append('caption', caption);
    if (region) formData.append('region', region);
    if (year) formData.append('year', year);
    if (genre) formData.append('genre', genre);
    if (format) formData.append('format', format);
    if (resolution) formData.append('resolution', resolution);
    
    // 特殊参数
    if (codecFormat) formData.append('codecFormat', codecFormat);
    if (platform) formData.append('platform', platform);
    if (language) formData.append('language', language);
    if (eventType) formData.append('eventType', eventType);
    if (source) formData.append('source', source);
    if (style) formData.append('style', style);
    if (dataType) formData.append('dataType', dataType);
    formData.append('isMainland', isMainland.toString());

    try {
      const response = await axios.post('http://localhost:8080/torrent/fullrequest', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
        responseType: 'blob',
      });

      // 创建下载链接
      const url = window.URL.createObjectURL(new Blob([response.data]));
      const link = document.createElement('a');
      link.href = url;
      link.setAttribute('download', file.name);
      document.body.appendChild(link);
      link.click();
      link.remove();

      // 显示成功提示
      setShowSuccess(true);
      // 清空表单
      setTitle('');
      setDescription('');
      setCategoryId('');
      setFile(null);
      // 清空其他字段...
    } catch (err) {
      console.error('上传失败', err.response?.data || err.message);
      alert(err.response?.data || '上传失败，请检查后端是否启动');
    }
  };

//   return (
//   <div className="max-w-2xl mx-auto mt-10 p-6 bg-white shadow rounded">
//   <h2 className="text-2xl font-bold mb-6 text-orange-800 text-center border-b-2 border-orange-200 pb-3">上传种子</h2>
//   <form onSubmit={handleSubmit} className="space-y-6">
//     {/* 封面图片 - 大型上传区域 */}
//     <div className="form-group text-center">
//       <label className="upload-area text-orange-800 font-medium cursor-pointer p-8 border-2 border-dashed border-orange-300 rounded-lg hover:border-orange-400 transition-colors">
//         <svg xmlns="http://www.w3.org/2000/svg" className="mx-auto h-12 w-12 text-orange-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
//           <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
//         </svg>
//         <p className="mt-2 text-sm">点击或拖拽上传封面图片</p>
//         <input 
//           type="file" 
//           accept="image/*" 
//           onChange={(e) => setCoverImage(e.target.files[0])} 
//           className="hidden"
//           id="cover-image-upload"
//         />
//       </label>
//       <input 
//         type="file" 
//         accept="image/*" 
//         onChange={(e) => setCoverImage(e.target.files[0])} 
//         className="sr-only"
//         id="cover-image-upload-real"
//       />
//     </div>

//     {/* 种子文件 - 大型上传区域 */}
//     <div className="form-group text-center">
//       <label className="upload-area text-orange-800 font-medium cursor-pointer p-8 border-2 border-dashed border-orange-300 rounded-lg hover:border-orange-400 transition-colors">
//         <svg xmlns="http://www.w3.org/2000/svg" className="mx-auto h-12 w-12 text-orange-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
//           <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
//         </svg>
//         <p className="mt-2 text-sm">点击或拖拽上传种子文件(.torrent)</p>
//         <input 
//           type="file" 
//           accept=".torrent" 
//           onChange={(e) => setFile(e.target.files[0])} 
//           className="hidden"
//           id="torrent-file-upload"
//           required
//         />
//       </label>
//       <input 
//         type="file" 
//         accept=".torrent" 
//         onChange={(e) => setFile(e.target.files[0])} 
//         className="sr-only"
//         id="torrent-file-upload-real"
//         required
//       />
//     </div>

//     {/* 标题 */}
//     <div className="form-group">
//       <label className="form-label text-orange-800 text-center">标题</label>
//       <input
//         type="text"
//         placeholder="输入种子标题"
//         value={title}
//         onChange={(e) => setTitle(e.target.value)}
//         className="form-control text-center"
//         required
//       />
//     </div>

//     {/* 描述 */}
//     <div className="form-group">
//       <label className="form-label text-orange-800 text-center">描述</label>
//       <textarea
//         placeholder="输入种子描述"
//         value={description}
//         onChange={(e) => setDescription(e.target.value)}
//         className="form-control text-center"
//         rows={3}
//       />
//     </div>

//     {/* 分类 - 美化下拉框 */}
//     <div className="form-group">
//       <label className="form-label text-orange-800 text-center">分类</label>
//       <div className="relative">
//         <select
//           value={categoryId}
//           onChange={(e) => setCategoryId(e.target.value)}
//           className="custom-select"
//           required
//         >
//           <option value="">请选择分类</option>
//           {categories.map(cat => (
//             <option key={cat.categoryid} value={cat.categoryid}>{cat.category_name}</option>
//           ))}
//         </select>
//         <div className="select-arrow">
//           <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4 text-orange-500" viewBox="0 0 20 20" fill="currentColor">
//             <path fillRule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clipRule="evenodd" />
//           </svg>
//         </div>
//       </div>
//     </div>

//     {/* 动态字段 - 电影 */}
//     {showMovieFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800 text-center">字幕/说明</label>
//           <input
//             type="text"
//             placeholder="输入字幕/说明"
//             value={caption}
//             onChange={(e) => setCaption(e.target.value)}
//             className="form-control text-center"
//           />
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800 text-center">地区</label>
//           <div className="relative">
//             <select
//               value={region}
//               onChange={(e) => setRegion(e.target.value)}
//               className="custom-select"
//             >
//               <option value="">请选择地区</option>
//               {regions.map((region) => (
//                 <option key={region.value} value={region.value}>
//                   {region.label}
//                 </option>
//               ))}
//             </select>
//             <div className="select-arrow">
//               <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4 text-orange-500" viewBox="0 0 20 20" fill="currentColor">
//                 <path fillRule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clipRule="evenodd" />
//               </svg>
//             </div>
//           </div>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800 text-center">年份</label>
//           <input
//             type="text"
//             placeholder="输入年份"
//             value={year}
//             onChange={(e) => setYear(e.target.value)}
//             className="form-control text-center"
//           />
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800 text-center">类型</label>
//           <div className="relative">
//             <select
//               value={genre}
//               onChange={(e) => setGenre(e.target.value)}
//               className="custom-select"
//             >
//               <option value="">请选择类型</option>
//               {genres.map((format) => (
//                 <option key={format.value} value={format.value}>
//                   {format.label}
//                 </option>
//               ))}
//             </select>
//             <div className="select-arrow">
//               <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4 text-orange-500" viewBox="0 0 20 20" fill="currentColor">
//                 <path fillRule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clipRule="evenodd" />
//               </svg>
//             </div>
//           </div>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800 text-center">编码格式</label>
//           <div className="relative">
//             <select
//               value={codecFormat}
//               onChange={(e) => setCodecFormat(e.target.value)}
//               className="custom-select"
//             >
//               <option value="">请选择编码格式</option>
//               {codecFormats.map((format) => (
//                 <option key={format.value} value={format.value}>
//                   {format.label}
//                 </option>
//               ))}
//             </select>
//             <div className="select-arrow">
//               <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4 text-orange-500" viewBox="0 0 20 20" fill="currentColor">
//                 <path fillRule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clipRule="evenodd" />
//               </svg>
//             </div>
//           </div>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800 text-center">分辨率</label>
//           <div className="relative">
//             <select
//               value={resolution}
//               onChange={(e) => setResolution(e.target.value)}
//               className="custom-select"
//             >
//               <option value="">请选择分辨率</option>
//               {resolutions.map((resolution) => (
//                 <option key={resolution.value} value={resolution.value}>
//                   {resolution.label}
//                 </option>
//               ))}
//             </select>
//             <div className="select-arrow">
//               <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4 text-orange-500" viewBox="0 0 20 20" fill="currentColor">
//                 <path fillRule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clipRule="evenodd" />
//               </svg>
//             </div>
//           </div>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 剧集 */}
//     {showTvFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800">地区</label>
//           <select
//             value={region}
//             onChange={(e) => setRegion(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择地区</option>
//             {regions.map((region) => (
//               <option key={region.value} value={region.value}>
//                 {region.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">格式</label>
//           <select
//             value={format}
//             onChange={(e) => setFormat(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择格式</option>
//             {resolutions.map((format) => (
//               <option key={format.value} value={format.value}>
//                 {format.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">类型</label>
//           <select
//             value={genre}
//             onChange={(e) => setGenre(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择类型</option>
//             {genres.map((genre) => (
//               <option key={genre.value} value={genre.value}>
//                 {genre.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 游戏 */}
//     {showGameFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800">平台</label>
//           <select
//             value={platform}
//             onChange={(e) => setPlatform(e.target.value)} 
//             className="form-control"
//           >
//             <option value="">请选择平台</option>
//             {platforms.map((platform) => (
//               <option key={platform.value} value={platform.value}>
//                 {platform.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">类型</label>
//           <select
//             value={genre}
//             onChange={(e) => setGenre(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择类型</option>  
//             {gamegenres.map((genre) => (
//               <option key={genre.value} value={genre.value}>
//                 {genre.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">语言</label>
//           <select
//             value={language}
//             onChange={(e) => setLanguage(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择语言</option>
//             {languages.map((language) => (
//               <option key={language.value} value={language.value}>
//                 {language.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">数据类型</label>
//           <select
//             value={dataType}
//             onChange={(e) => setdataType(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择数据类型</option>
//             {dataTypes.map((dataType) => (
//               <option key={dataType.value} value={dataType.value}>
//                 {dataType.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 综艺 */}
//     {showvarietyFields && (
//       <>
//         <div className="form-group">
//           <label className="flex items-center">
//             <input
//               type="checkbox"
//               checked={isMainland}
//               onChange={(e) => setIsMainland(e.target.checked)}
//               className="mr-2"
//             />
//             是否大陆综艺
//           </label>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">类型</label>
//           <select
//             value={style}
//             onChange={(e) => setStyle(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择类型</option>
//             {varietygenres.map((style) => (
//               <option key={style.value} value={style.value}>
//                 {style.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">格式</label>
//           <select
//             value={format}
//             onChange={(e) => setFormat(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择格式</option>
//             {resolutions.map((format) => (
//               <option key={format.value} value={format.value}>
//                 {format.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 动漫 */}
//     {showAnimeFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800">类型</label>
//           <select
//             value={genre}
//             onChange={(e) => setGenre(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择类型</option>
//             {anigenres.map((genre) => (
//               <option key={genre.value} value={genre.value}>
//                 {genre.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">格式</label>
//           <select
//             value={format}
//             onChange={(e) => setFormat(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择格式</option>
//             {animeformats.map((format) => (
//               <option key={format.value} value={format.value}>
//                 {format.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">分辨率</label>
//           <select
//             value={resolution}
//             onChange={(e) => setResolution(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择分辨率</option>
//             {resolutions.map((resolution) => (
//               <option key={resolution.value} value={resolution.value}>
//                 {resolution.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 学习 */}
//     {showlearningFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800">类型</label>
//           <select
//             value={genre}
//             onChange={(e) => setGenre(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择类型</option>
//             {learninggenres.map((genre) => (
//               <option key={genre.value} value={genre.value}>
//                 {genre.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">格式</label>
//           <select
//             value={format}
//             onChange={(e) => setFormat(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择格式</option>
//             {learningformats.map((format) => (
//               <option key={format.value} value={format.value}>
//                 {format.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 软件 */}
//     {showsoftwareFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800">平台</label>
//           <select
//             value={platform}
//             onChange={(e) => setPlatform(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择平台</option>
//             {softwareplatforms.map((platform) => (
//               <option key={platform.value} value={platform.value}>
//                 {platform.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">类型</label>
//           <select
//             value={genre}
//             onChange={(e) => setGenre(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择类型</option>
//             {softwaregenres.map((genre) => (
//               <option key={genre.value} value={genre.value}>
//                 {genre.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">格式</label>
//           <select
//             value={format}
//             onChange={(e) => setFormat(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择格式</option>
//             {softwareformats.map((format) => (
//               <option key={format.value} value={format.value}>
//                 {format.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 体育 */}
//     {showsportsFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800">类型</label>
//           <select
//             value={genre}
//             onChange={(e) => setGenre(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择类型</option>
//             {sportsgenres.map((genre) => (
//               <option key={genre.value} value={genre.value}>
//                 {genre.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">格式</label>
//           <select
//             value={format}
//             onChange={(e) => setFormat(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择格式</option>
//             {resolutions.map((format) => (
//               <option key={format.value} value={format.value}>
//                 {format.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">赛事类型</label>
//           <select
//             value={eventType}
//             onChange={(e) => setEventType(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择赛事类型</option>
//             {eventTypes.map((eventType) => (
//               <option key={eventType.value} value={eventType.value}>
//                 {eventType.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 纪录片 */}
//     {showdocFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800">年份</label>
//           <input
//             type="text"
//             placeholder="如 1999, 2020"
//             value={year}
//             onChange={(e) => setYear(e.target.value)}
//             className="form-control"
//           />
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">视频源</label>
//           <select
//             value={source}
//             onChange={(e) => setSource(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择视频源</option>
//             {sourceTypes.map((source) => (
//               <option key={source.value} value={source.value}>
//                 {source.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">格式</label>
//           <select
//             value={format}
//             onChange={(e) => setFormat(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择格式</option>
//             {resolutions.map((format) => (
//               <option key={format.value} value={format.value}>
//                 {format.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 音乐 */}
//     {showMusicFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800">类型</label>
//           <select
//             value={genre}
//             onChange={(e) => setGenre(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择类型</option>
//             {musicgenres.map((genre) => (
//               <option key={genre.value} value={genre.value}>
//                 {genre.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">地区</label>
//           <select
//             value={region}
//             onChange={(e) => setRegion(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择地区</option>
//             {regions.map((region) => (
//               <option key={region.value} value={region.value}>
//                 {region.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">风格</label>
//           <select
//             value={style}
//             onChange={(e) => setStyle(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择风格</option>
//             {musicstyles.map((style) => (
//               <option key={style.value} value={style.value}>
//                 {style.label}
//               </option>
//             ))}
//           </select>
//         </div>
//         <div className="form-group">
//           <label className="form-label text-orange-800">格式</label>
//           <select
//             value={format}
//             onChange={(e) => setFormat(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择格式</option>
//             {musicformats.map((format) => (
//               <option key={format.value} value={format.value}>
//                 {format.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}

//     {/* 动态字段 - 其他 */}
//     {showotherFields && (
//       <>
//         <div className="form-group">
//           <label className="form-label text-orange-800">类型</label>
//           <select
//             value={genre}
//             onChange={(e) => setGenre(e.target.value)}
//             className="form-control"
//           >
//             <option value="">请选择类型</option>
//             {othergenres.map((genre) => (
//               <option key={genre.value} value={genre.value}>
//                 {genre.label}
//               </option>
//             ))}
//           </select>
//         </div>
//       </>
//     )}


//     {/* 其他动态字段... (保持相同的美化样式) */}
//     {/* 这里省略了其他动态字段的代码，但它们都使用相同的自定义下拉框样式 */}
    
//     {/* 提交按钮 - 居中 */}
//     <div className="text-center">
//       <button 
//         type="submit" 
//         className="submit-btn"
//       >
//         上传种子
//       </button>
//     </div>

//     {showSuccess && (
//       <div className="success-message text-center">
//         上传成功！
//       </div>
//     )}
//   </form>
// </div>
//   );
// }
return (
    <div className="container">
      <div className="card">
        <h2 className="title">上传种子</h2>
        <Form
          layout="vertical"
          onFinish={handleSubmit}
          className="form"
        >
         {/* 封面图片 - 自定义上传区域 */}
<Form.Item
  name="coverImage"
   label={<span style={{ fontSize: '19px'  , fontWeight: 'bold'}}>封面图片</span>} 
  rules={[{ required: true, message: '请上传封面图片' }]}
>
  <div 
    className="uploadArea"
    onClick={() => document.getElementById('cover-image-upload').click()}
  >
    <InboxOutlined className="uploadIcon" />
    <p className="uploadText">点击或拖拽上传封面图片</p>
    <input
      type="file"
      accept="image/*"
      onChange={(e) => {
        setCoverImage(e.target.files[0]);
        form.setFieldsValue({ coverImage: e.target.files[0] });
      }}
      className="hiddenInput"
      id="cover-image-upload"
    />
  </div>
</Form.Item>

{/* 种子文件 - 自定义上传区域 */}
<Form.Item
  name="torrentFile"
   label={<span style={{ fontSize: '19px' , fontWeight: 'bold'}}>种子文件</span>} 
  rules={[{ required: true, message: '请上传.torrent文件' }]}
>
  <div 
    className="uploadArea"
    onClick={() => document.getElementById('torrent-file-upload').click()}
  >
    <InboxOutlined className="uploadIcon" />
    <p className="uploadText">点击或拖拽上传种子文件(.torrent)</p>
    <input
      type="file"
      accept=".torrent"
      onChange={(e) => {
        setFile(e.target.files[0]);
        form.setFieldsValue({ torrentFile: e.target.files[0] });
      }}
      className="hiddenInput"
      id="torrent-file-upload"
    />
  </div>
</Form.Item>

          {/* 标题 */}
          <Form.Item
            name="title"
            label={<span style={{ fontSize: '19px'  , fontWeight: 'bold'}}>标题</span>}  // 直接包裹label
            rules={[{ required: true, message: '请输入标题' }]}
            //labelCol={{ style: { fontSize: '30px !important ' } }} // ✅ 调整 Label 字体
          >
            <Input
              placeholder="输入种子标题"
              value={title}
              onChange={(e) => {
                setTitle(e.target.value);
                form.setFieldsValue({ title: e.target.value });
              }}
              //style={styles.input}
              style={{ fontSize: '19px' }} // ✅ 调整 Input 字体
            />
          </Form.Item>

          {/* 描述 */}
          <Form.Item
            name="description"
             label={<span style={{ fontSize: '19px'  , fontWeight: 'bold'}}>描述</span>} 
          >
            <TextArea
              placeholder="输入种子描述"
              value={description}
              onChange={(e) => {
                setDescription(e.target.value);
                form.setFieldsValue({ description: e.target.value });
              }}
              rows={3}
              style={styles.textArea}
            />
          </Form.Item>

          {/* 分类 - 美化下拉框 */}
          <Form.Item
            name="categoryId"
             label={<span style={{ fontSize: '19px' , fontWeight: 'bold' }}>分类</span>} 
            rules={[{ required: true, message: '请选择分类' }]}
          >
            <Select
              placeholder="请选择分类"
              value={categoryId}
              onChange={(value) => {
                const stringValue = String(value);
                setCategoryId(stringValue);
                console.log('Selected category ID:', stringValue);
                form.setFieldsValue({ categoryId: value });
                // 触发分类变化后的逻辑
                setShowMovieFields(value === '1');
                setShowTvFields(value === '2');
                setShowAnimeFields(value === '4');
                setShowGameFields(value === '5');
                setShowvarietyFields(value === '6');
                setShowMusicFields(value === '3');
                setShowlearningFields(value === '9');
                setShowsoftwareFields(value === '8');
                setShowsportsFields(value === '7');
                setShowdocFields(value === '10');
                setShowotherFields(value === '11');
              }}
              style={styles.select}
            >
              <Option value="">请选择分类</Option>
              {categories.map(cat => (
                <Option key={cat.categoryid} value={cat.categoryid}>{cat.category_name}</Option>
              ))}
            </Select>
          </Form.Item>

      {/* 动态字段 - 电影 */}
      {showMovieFields && (
        <>
          <Form.Item
            name="caption"
            label="字幕/说明"
            rules={[{ required: true, message: '请输入字幕/说明' }]}
          >
            <Input
              placeholder="输入字幕/说明"
              value={caption}
              onChange={(e) => {
                setCaption(e.target.value);
                form.setFieldsValue({ caption: e.target.value });
              }}
              className="text-center"
            />
          </Form.Item>
          <Form.Item
            name="region"
            label="地区"
          >
            <Select
              placeholder="请选择地区"
              value={region}
              onChange={(value) => {
                setRegion(value);
                form.setFieldsValue({ region: value });
              }}
              className="w-full"
            >
              <Option value="">请选择地区</Option>
              {regions.map((region) => (
                <Option key={region.value} value={region.value}>
                  {region.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="year"
            label="年份"
          >
            <Input
              placeholder="输入年份"
              value={year}
              onChange={(e) => {
                setYear(e.target.value);
                form.setFieldsValue({ year: e.target.value });
              }}
              className="text-center"
            />
          </Form.Item>
          <Form.Item
            name="genre"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={genre}
              onChange={(value) => {
                setGenre(value);
                form.setFieldsValue({ genre: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {genres.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="codecFormat"
            label="编码格式"
          >
            <Select
              placeholder="请选择编码格式"
              value={codecFormat}
              onChange={(value) => {
                setCodecFormat(value);
                form.setFieldsValue({ codecFormat: value });
              }}
              className="w-full"
            >
              <Option value="">请选择编码格式</Option>
              {codecFormats.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="resolution"
            label="分辨率"
          >
            <Select
              placeholder="请选择分辨率"
              value={resolution}
              onChange={(value) => {
                setResolution(value);
                form.setFieldsValue({ resolution: value });
              }}
              className="w-full"
            >
              <Option value="">请选择分辨率</Option>
              {resolutions.map((resolution) => (
                <Option key={resolution.value} value={resolution.value}>
                  {resolution.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 剧集 */}
      {showTvFields && (
        <>
          <Form.Item
            name="region"
            label="地区"
          >
            <Select
              placeholder="请选择地区"
              value={region}
              onChange={(value) => {
                setRegion(value);
                form.setFieldsValue({ region: value });
              }}
              className="w-full"
            >
              <Option value="">请选择地区</Option>
              {regions.map((region) => (
                <Option key={region.value} value={region.value}>
                  {region.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="format"
            label="格式"
          >
            <Select
              placeholder="请选择格式"
              value={format}
              onChange={(value) => {
                setFormat(value);
                form.setFieldsValue({ format: value });
              }}
              className="w-full"
            >
              <Option value="">请选择格式</Option>
              {resolutions.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="genre"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={genre}
              onChange={(value) => {
                setGenre(value);
                form.setFieldsValue({ genre: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {genres.map((genre) => (
                <Option key={genre.value} value={genre.value}>
                  {genre.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 游戏 */}
      {showGameFields && (
        <>
          <Form.Item
            name="platform"
            label="平台"
          >
            <Select
              placeholder="请选择平台"
              value={platform}
              onChange={(value) => {
                setPlatform(value);
                form.setFieldsValue({ platform: value });
              }}
              className="w-full"
            >
              <Option value="">请选择平台</Option>
              {platforms.map((platform) => (
                <Option key={platform.value} value={platform.value}>
                  {platform.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="genre"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={genre}
              onChange={(value) => {
                setGenre(value);
                form.setFieldsValue({ genre: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {gamegenres.map((genre) => (
                <Option key={genre.value} value={genre.value}>
                  {genre.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="language"
            label="语言"
          >
            <Select
              placeholder="请选择语言"
              value={language}
              onChange={(value) => {
                setLanguage(value);
                form.setFieldsValue({ language: value });
              }}
              className="w-full"
            >
              <Option value="">请选择语言</Option>
              {languages.map((language) => (
                <Option key={language.value} value={language.value}>
                  {language.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="dataType"
            label="数据类型"
          >
            <Select
              placeholder="请选择数据类型"
              value={dataType}
              onChange={(value) => {
                setDataType(value);
                form.setFieldsValue({ dataType: value });
              }}
              className="w-full"
            >
              <Option value="">请选择数据类型</Option>
              {dataTypes.map((dataType) => (
                <Option key={dataType.value} value={dataType.value}>
                  {dataType.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 综艺 */}
      {showvarietyFields && (
        <>
          <Form.Item
            name="isMainland"
            label="是否大陆综艺"
            valuePropName="checked"
          >
            <Switch 
              checked={isMainland}
              onChange={(checked) => {
                setIsMainland(checked);
                form.setFieldsValue({ isMainland: checked });
              }}
            />
          </Form.Item>
          <Form.Item
            name="style"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={style}
              onChange={(value) => {
                setStyle(value);
                form.setFieldsValue({ style: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {varietygenres.map((style) => (
                <Option key={style.value} value={style.value}>
                  {style.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="format"
            label="格式"
          >
            <Select
              placeholder="请选择格式"
              value={format}
              onChange={(value) => {
                setFormat(value);
                form.setFieldsValue({ format: value });
              }}
              className="w-full"
            >
              <Option value="">请选择格式</Option>
              {resolutions.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 动漫 */}
      {showAnimeFields && (
        <>
          <Form.Item
            name="genre"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={genre}
              onChange={(value) => {
                setGenre(value);
                form.setFieldsValue({ genre: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {anigenres.map((genre) => (
                <Option key={genre.value} value={genre.value}>
                  {genre.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="format"
            label="格式"
          >
            <Select
              placeholder="请选择格式"
              value={format}
              onChange={(value) => {
                setFormat(value);
                form.setFieldsValue({ format: value });
              }}
              className="w-full"
            >
              <Option value="">请选择格式</Option>
              {animeformats.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="resolution"
            label="分辨率"
          >
            <Select
              placeholder="请选择分辨率"
              value={resolution}
              onChange={(value) => {
                setResolution(value);
                form.setFieldsValue({ resolution: value });
              }}
              className="w-full"
            >
              <Option value="">请选择分辨率</Option>
              {resolutions.map((resolution) => (
                <Option key={resolution.value} value={resolution.value}>
                  {resolution.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 学习 */}
      {showlearningFields && (
        <>
          <Form.Item
            name="genre"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={genre}
              onChange={(value) => {
                setGenre(value);
                form.setFieldsValue({ genre: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {learninggenres.map((genre) => (
                <Option key={genre.value} value={genre.value}>
                  {genre.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="format"
            label="格式"
          >
            <Select
              placeholder="请选择格式"
              value={format}
              onChange={(value) => {
                setFormat(value);
                form.setFieldsValue({ format: value });
              }}
              className="w-full"
            >
              <Option value="">请选择格式</Option>
              {learningformats.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 软件 */}
      {showsoftwareFields && (
        <>
          <Form.Item
            name="platform"
            label="平台"
          >
            <Select
              placeholder="请选择平台"
              value={platform}
              onChange={(value) => {
                setPlatform(value);
                form.setFieldsValue({ platform: value });
              }}
              className="w-full"
            >
              <Option value="">请选择平台</Option>
              {softwareplatforms.map((platform) => (
                <Option key={platform.value} value={platform.value}>
                  {platform.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="genre"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={genre}
              onChange={(value) => {
                setGenre(value);
                form.setFieldsValue({ genre: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {softwaregenres.map((genre) => (
                <Option key={genre.value} value={genre.value}>
                  {genre.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="format"
            label="格式"
          >
            <Select
              placeholder="请选择格式"
              value={format}
              onChange={(value) => {
                setFormat(value);
                form.setFieldsValue({ format: value });
              }}
              className="w-full"
            >
              <Option value="">请选择格式</Option>
              {softwareformats.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 体育 */}
      {showsportsFields && (
        <>
          <Form.Item
            name="genre"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={genre}
              onChange={(value) => {
                setGenre(value);
                form.setFieldsValue({ genre: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {sportsgenres.map((genre) => (
                <Option key={genre.value} value={genre.value}>
                  {genre.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="format"
            label="格式"
          >
            <Select
              placeholder="请选择格式"
              value={format}
              onChange={(value) => {
                setFormat(value);
                form.setFieldsValue({ format: value });
              }}
              className="w-full"
            >
              <Option value="">请选择格式</Option>
              {resolutions.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="eventType"
            label="赛事类型"
          >
            <Select
              placeholder="请选择赛事类型"
              value={eventType}
              onChange={(value) => {
                setEventType(value);
                form.setFieldsValue({ eventType: value });
              }}
              className="w-full"
            >
              <Option value="">请选择赛事类型</Option>
              {eventTypes.map((eventType) => (
                <Option key={eventType.value} value={eventType.value}>
                  {eventType.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 纪录片 */}
      {showdocFields && (
        <>
          <Form.Item
            name="year"
            label="年份"
          >
            <Input
              placeholder="如 1999, 2020"
              value={year}
              onChange={(e) => {
                setYear(e.target.value);
                form.setFieldsValue({ year: e.target.value });
              }}
              className="w-full"
            />
          </Form.Item>
          <Form.Item
            name="source"
            label="视频源"
          >
            <Select
              placeholder="请选择视频源"
              value={source}
              onChange={(value) => {
                setSource(value);
                form.setFieldsValue({ source: value });
              }}
              className="w-full"
            >
              <Option value="">请选择视频源</Option>
              {sourceTypes.map((source) => (
                <Option key={source.value} value={source.value}>
                  {source.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="format"
            label="格式"
          >
            <Select
              placeholder="请选择格式"
              value={format}
              onChange={(value) => {
                setFormat(value);
                form.setFieldsValue({ format: value });
              }}
              className="w-full"
            >
              <Option value="">请选择格式</Option>
              {resolutions.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 音乐 */}
      {showMusicFields && (
        <>
          <Form.Item
            name="genre"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={genre}
              onChange={(value) => {
                setGenre(value);
                form.setFieldsValue({ genre: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {musicgenres.map((genre) => (
                <Option key={genre.value} value={genre.value}>
                  {genre.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="region"
            label="地区"
          >
            <Select
              placeholder="请选择地区"
              value={region}
              onChange={(value) => {
                setRegion(value);
                form.setFieldsValue({ region: value });
              }}
              className="w-full"
            >
              <Option value="">请选择地区</Option>
              {regions.map((region) => (
                <Option key={region.value} value={region.value}>
                  {region.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="style"
            label="风格"
          >
            <Select
              placeholder="请选择风格"
              value={style}
              onChange={(value) => {
                setStyle(value);
                form.setFieldsValue({ style: value });
              }}
              className="w-full"
            >
              <Option value="">请选择风格</Option>
              {musicstyles.map((style) => (
                <Option key={style.value} value={style.value}>
                  {style.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
          <Form.Item
            name="format"
            label="格式"
          >
            <Select
              placeholder="请选择格式"
              value={format}
              onChange={(value) => {
                setFormat(value);
                form.setFieldsValue({ format: value });
              }}
              className="w-full"
            >
              <Option value="">请选择格式</Option>
              {musicformats.map((format) => (
                <Option key={format.value} value={format.value}>
                  {format.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}

      {/* 动态字段 - 其他 */}
      {showotherFields && (
        <>
          <Form.Item
            name="genre"
            label="类型"
          >
            <Select
              placeholder="请选择类型"
              value={genre}
              onChange={(value) => {
                setGenre(value);
                form.setFieldsValue({ genre: value });
              }}
              className="w-full"
            >
              <Option value="">请选择类型</Option>
              {othergenres.map((genre) => (
                <Option key={genre.value} value={genre.value}>
                  {genre.label}
                </Option>
              ))}
            </Select>
          </Form.Item>
        </>
      )}
 {/* 提交按钮 */}
          <Form.Item>
            <Button 
              type="primary" 
              htmlType="submit" 
              className="submitButton"
              onMouseOver={(e) => e.target.style.backgroundColor = '#ff7f00'}
              onMouseOut={(e) => e.target.style.backgroundColor = '#ff8c00'}
            >
              上传种子
            </Button>
          </Form.Item>

          {showSuccess && (
            <div className="successMessage">
              上传成功！
            </div>
          )}
        </Form>
      </div>
    </div>
  );
}

export default UploadTorrentFull;

