import React, { useState } from 'react';
import { Layout, Menu, Button } from 'antd';
import {
    FileTextOutlined,
    FlagOutlined,
    TagsOutlined,
    DeploymentUnitOutlined,
    HomeOutlined,
    FileSearchOutlined
} from '@ant-design/icons';
import { useNavigate } from 'react-router-dom';
import PostAdminPanel from '../components/PostAdminPanel';
import AdminActivityManager from '../components/AdminActivityManager';
import ActivityAdminPanel from '../components/ActivityAdminPanel';
import RequestAdminPanel from '../components/RequestAdminPanel';
import ComplainAdminPanel from '../components/ComplainAdminPanel';
import TorrentManagement from '../components/torrentmanage';
import UserManagement from '../components/UserManagement';

const { Header, Sider, Content, Footer } = Layout;

const AdminPage = () => {
    const navigate = useNavigate();
    const [selectedKey, setSelectedKey] = useState('posts');

    const renderContent = () => {
        switch (selectedKey) {
            case 'posts':
                return <PostAdminPanel />;
            case 'activities':
                return <ActivityAdminPanel />;
            case 'requests':
                return <RequestAdminPanel />;
            case 'complain':
                return <ComplainAdminPanel />;
            case 'torrent':
                return <TorrentManagement/>;
                 case 'user':
                return <UserManagement/>;
            default:
                return null;
        }
    };

    return (
        <Layout style={{ minHeight: '100vh' }}>
            {/* 侧边栏 */}
            <Sider breakpoint="lg" collapsedWidth="0" theme="dark">
                <div className="logo" style={{
                    height: 64,
                    display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'center',
                    fontSize: 22,
                    color: 'white',
                    fontWeight: 'bold',
                }}>
                    后台管理
                </div>
                <Menu
                    theme="dark"
                    mode="inline"
                    selectedKeys={[selectedKey]}
                    onClick={({ key }) => setSelectedKey(key)}
                    items={[
                        {
                            key: 'posts',
                            icon: <FileTextOutlined />,
                            label: '帖子管理',
                        },
                        {
                            key: 'activities',
                            icon: <DeploymentUnitOutlined />,
                            label: '公告管理',
                        },
                        {
                            key: 'requests',
                            icon: <FileSearchOutlined />,
                            label: '求助帖管理',
                        },
                        {
                            key: 'complain',
                            icon: <FlagOutlined />,
                            label: '举报管理',
                        },
                        {
                            key: 'torrent',
                            icon: <TagsOutlined />,
                            label: '种子管理',
                        },
                                                {
                            key: 'user',
                            icon: <TagsOutlined />,
                            label: '用户管理',
                        },
                    ]}
                />
                <div style={{ padding: 16 }}>
                    <Button
                        type="primary"
                        block
                        icon={<HomeOutlined />}
                        onClick={() => navigate('/')}
                    >
                        返回首页
                    </Button>
                </div>
            </Sider>

            {/* 内容区 */}
            <Layout>
                <Header style={{ background: '#fff', padding: '0 24px', fontSize: 20 }}>
                    {(() => {
                        switch (selectedKey) {
                            case 'posts': return '📄 帖子管理';
                            case 'activities': return '🎯 公告管理';
                            case 'requests': return '🆘 求助帖管理';
                            case 'complain': return '🚨 举报管理';
                            case 'torrent': return '🧲 种子管理';
                            default: return '';
                        }
                    })()}
                </Header>
                <Content style={{ margin: '24px 16px 0', padding: 24, background: '#fff', minHeight: '85vh' }}>
                    {renderContent()}
                </Content>
                <Footer style={{ textAlign: 'center' }}>
                    PT管理系统 ©{new Date().getFullYear()} Created by Jiaxin Liu, Man Yang, Shuo Wang
                </Footer>
            </Layout>
        </Layout>
    );
};

export default AdminPage;
