import request from './request'

export const authApi = {
  /**
   * 用户登录
   */
  async login(loginData) {
    console.log('📤 发送登录数据:', loginData)
    
    const requestData = {
      user: loginData.user,
      password: loginData.password
    }
    
    return request({
      url: '/auth/login',  // 需要 /api 前缀
      method: 'post',
      data: requestData
    })
  },

  /**
   * 用户注册
   */
  async register(registerData) {
    console.log('📤 发送注册数据:', registerData)
    
    const requestData = {
      username: registerData.username,
      email: registerData.email,
      password: registerData.password
    }
    
    return request({
      url: '/auth/register',  // 需要 /api 前缀
      method: 'post',
      data: requestData
    })
  },

  /**
   * 用户登出
   */
  logout() {
    return request({
      url: '/auth/logout',  // 需要 /api 前缀
      method: 'post'
    })
  },

  /**
   * 获取登录状态
   */
  getStatus() {
    return request({
      url: '/auth/status',  // 需要 /api 前缀
      method: 'get'
    })
  }
}

export default authApi