import request from './request'

export function getAllForums() {
    return request({
        url: '/api/forums',
        method: 'get'
    })
}

export function getForumById(id) {
    return request({
        url: `/api/forums/${id}`,
        method: 'get'
    })
}

export function createForum(data) {
    return request({
        url: '/api/forums',
        method: 'post',
        data
    })
}

export function updateForum(id, data) {
    return request({
        url: `/api/forums/${id}`,
        method: 'put',
        data
    })
}

export function deleteForum(id) {
    return request({
        url: `/api/forums/${id}`,
        method: 'delete'
    })
} 