import request from './request'

export function getAllTags() {
    return request({
        url: '/api/tags',
        method: 'get'
    })
}

export function createTag(data) {
    return request({
        url: '/api/tags',
        method: 'post',
        data
    })
}

export function deleteTag(tagId) {
    return request({
        url: `/api/tags/${tagId}`,
        method: 'delete'
    })
}

export function getTopicTags(topicId) {
    return request({
        url: `/api/tags/topics/${topicId}`,
        method: 'get'
    })
}

export function assignTagsToTopic(topicId, tagNames) {
    return request({
        url: `/api/tags/topics/${topicId}/assign`,
        method: 'post',
        data: tagNames
    })
} 