import request from './request'

export function getPostsByTopic(topicId) {
    return request({
        url: `/api/posts/topic/${topicId}`,
        method: 'get'
    })
}

export function getPostTreeByTopic(topicId) {
    return request({
        url: `/api/posts/topic/${topicId}/tree`,
        method: 'get'
    })
}

export function createPost(data) {
    return request({
        url: '/api/posts',
        method: 'post',
        data
    })
}

export function getPostById(id) {
    return request({
        url: `/api/posts/${id}`,
        method: 'get'
    })
}

export function updatePost(id, data) {
    return request({
        url: `/api/posts/${id}`,
        method: 'put',
        data
    })
}

export function deletePost(id) {
    return request({
        url: `/api/posts/${id}`,
        method: 'delete'
    })
}

export function getUserPosts(userId) {
    return request({
        url: `/api/posts/user/${userId}`,
        method: 'get'
    })
} 