import request from './request'

export function likePost(postId, userId) {
    return request({
        url: `/api/post-likes/${postId}/like/${userId}`,
        method: 'post'
    })
}

export function unlikePost(postId, userId) {
    return request({
        url: `/api/post-likes/${postId}/unlike/${userId}`,
        method: 'delete'
    })
}

export function getPostLikeCount(postId) {
    return request({
        url: `/api/post-likes/${postId}/count`,
        method: 'get'
    })
} 