import request from './request';

export const getTopicDetail = (id) => request.get(` /posts/${id}`);
export const getTopicPosts = (topicId, page = 1, size = 20) => request.get(`/posts/topic/${topicId}`, { params: { page, size } });
export const createPost = (data) => request.post('/posts', data);
export const updatePost = (id, data) => request.put(`/posts/${id}`, data);
export const deletePost = (id) => request.delete(`/posts/${id}`);