import request from './request'

export function subscribeTopic(data) {
    return request({
        url: '/api/subscriptions/subscribe',
        method: 'post',
        data
    })
}

export function unsubscribeTopic(data) {
    return request({
        url: '/api/subscriptions/unsubscribe',
        method: 'post',
        data
    })
}

export function checkSubscription(topicId) {
    return request({
        url: '/api/subscriptions/check',
        method: 'get',
        params: { topicId }
    })
}

export function getSubscriptionList() {
    return request({
        url: '/api/subscriptions/list',
        method: 'get'
    })
} 