import request from './request'

export function getAllTopics() {
    return request({
        url: '/api/topics',
        method: 'get'
    })
}

export function getTopicById(id) {
    return request({
        url: `/api/topics/${id}`,
        method: 'get'
    })
}

export function getTopicsByForum(forumId) {
    return request({
        url: `/api/topics/forum/${forumId}`,
        method: 'get'
    })
}

export function createTopic(data) {
    return request({
        url: '/api/topics',
        method: 'post',
        data
    })
}

export function updateTopic(id, data) {
    return request({
        url: `/api/topics/${id}`,
        method: 'put',
        data
    })
}

export function deleteTopic(id) {
    return request({
        url: `/api/topics/${id}`,
        method: 'delete'
    })
}

export function searchTopics(query, forumId, page = 0, size = 10) {
    return request({
        url: '/api/topics/search',
        method: 'get',
        params: { q: query, forumId, page, size }
    })
}
