// vue.config.js
const { defineConfig } = require('@vue/cli-service')

module.exports = defineConfig({
  transpileDependencies: true,

  /*  dev 服务只跑在 8080；真正的后端地址改用
      环境变量 VUE_APP_BACKEND，默认仍指向 8081  */
  devServer: {
    port: 8080,
    proxy: {
      // ❶ 统一以 /api 开头的请求全部反向代理
      '/api': {
        target: process.env.VUE_APP_BACKEND || 'http://localhost:8081',
        changeOrigin: true,
        ws: true,
        secure: false,
        logLevel: 'debug',
        onProxyReq: (proxyReq, req, res) => {
          console.log('🔄 代理请求:', req.method, req.url, '→', 'http://localhost:8081' + req.url)
        },
        onProxyRes: (proxyRes, req, res) => {
          console.log('📨 代理响应:', proxyRes.statusCode, req.url)
        },
        onError: (err, req, res) => {
          console.error('❌ 代理错误:', err.message)
        }
      },// 这里需要闭合 /api 的配置

      /* ❷ 可选：如果你项目里还有没改完的
            /category、/torrent、/auth 旧写法，保留兼容性。
            改完之后，把这一段删掉也行。 */
      '/category': {
        target: process.env.VUE_APP_BACKEND || 'http://localhost:8081',
        changeOrigin: true,
        pathRewrite: { '^/category': '/api/category' }
      },
      '/torrent': {
        target: process.env.VUE_APP_BACKEND || 'http://localhost:8081',
        changeOrigin: true,
        pathRewrite: { '^/torrent': '/api/torrent' }
      },
      '/auth': {
        target: process.env.VUE_APP_BACKEND || 'http://localhost:8081',
        changeOrigin: true,
        pathRewrite: { '^/auth': '/api/auth' }
      }
    }
  }
})