import request from './request'

/**
 * 上传种子
 * @param {FormData} formData - 包含种子文件和相关信息的表单数据
 * @returns {Promise}
 */
export function uploadTorrent(formData) {
  return request({
    url: '/torrent/upload',
    method: 'post',
    data: formData,
    headers: {
      'Content-Type': 'multipart/form-data'
    }
  })
}

/**
 * 获取分类列表
 * @returns {Promise}
 */
export function getCategories() {
  return request({
    url: '/category/list', // 注意这里不需要加 /api，已经在代理中配置了
    method: 'get'
  })
}

/**
 * 获取标签列表
 * @returns {Promise}
 * 暂时还没有获取标签的列表
 */
export function getTags() {
    console.log('调用获取标签列表API...')
    // 由于后端没有标签的Controller，返回模拟数据
    return new Promise((resolve) => {
      setTimeout(() => {
        resolve({
          data: [
            { id: 1, name: 'linux' },
            { id: 2, name: 'ios' },
            { id: 3, name: 'ubuntu' }
          ]
        })
      }, 100)
    })
  }

/**
 * 获取种子详情
 * @param {string} infoHash - 种子的info hash
 * @returns {Promise}
 */
export function getTorrentDetail(infoHash) {
  return request({
    url: `/torrent/${infoHash}`,
    method: 'get'
  })
}

/**
 * 获取种子列表
 * @param {Object} params - 查询参数
 * @returns {Promise}
 */
export function getTorrents(params) {
  return request({
    url: '/torrents',
    method: 'get',
    params
  })
}