import { createRouter, createWebHistory } from 'vue-router'
import { ElMessage } from 'element-plus'

// 路由组件
import LoginView from '@/views/auth/LoginView.vue'
import RegisterView from '@/views/auth/RegisterView.vue'
import HomeView from '@/views/HomeView.vue'

const routes = [
  {
    path: '/',
    redirect: '/login'
  },
  {
    path: '/login',
    name: 'Login',
    component: LoginView,
    meta: {
      title: 'PT Tracker - 登录',
      requiresGuest: true
    }
  },
  {
    path: '/register',
    name: 'Register',
    component: RegisterView,
    meta: {
      title: 'PT Tracker - 注册',
      requiresGuest: true
    }
  },
  {
    path: '/home',
    name: 'Home',
    component: HomeView,
    meta: {
      title: 'PT Tracker - 首页',
      requiresAuth: true
    }
  },
  {
    path: '/:pathMatch(.*)*',
    redirect: '/login'
  }
]

const router = createRouter({
  history: createWebHistory(),
  routes
})

// 路由守卫
router.beforeEach((to, from, next) => {
  // 设置页面标题
  if (to.meta.title) {
    document.title = to.meta.title
  }
  
  // 检查登录状态
  const isLoggedIn = localStorage.getItem('isLoggedIn') === 'true'
  
  console.log(`路由跳转: ${from.path} -> ${to.path}, 登录状态: ${isLoggedIn}`)
  
  // 需要登录但未登录
  if (to.meta.requiresAuth && !isLoggedIn) {
    ElMessage.warning('请先登录')
    next('/login')
    return
  }
  
  // 已登录但访问登录/注册页
  if (to.meta.requiresGuest && isLoggedIn) {
    next('/home')
    return
  }
  
  next()
})

export default router
