package com.github.example.pt.entity;

import jakarta.persistence.*;
import lombok.*;

import java.time.LocalDateTime;

@Entity
@Table(name = "topic_views")
@Data
@NoArgsConstructor
@AllArgsConstructor
@IdClass(TopicViewId.class)
public class TopicView {

    @Id
    @ManyToOne
    @JoinColumn(name = "topic_id")
    private Topic topic;

    @Id
    @ManyToOne
    @JoinColumn(name = "user_id")
    private User user;

    @Column(name = "last_viewed_at", nullable = false)
    private LocalDateTime lastViewedAt;
}