package com.github.example.pt.service;

import com.github.example.pt.entity.Forum;
import com.github.example.pt.entity.Topic;
import com.github.example.pt.repository.TopicRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

@Service
public class TopicService {

    @Autowired
    private TopicRepository topicRepository;

    public List<Topic> getAllTopics() {
        return topicRepository.findAll();
    }

    public List<Topic> getTopicsByForum(Forum forum) {
        return topicRepository.findByForum(forum);
    }

    public Optional<Topic> getTopicById(Long id) {
        return topicRepository.findById(id);
    }

    public Topic createTopic(Topic topic) {
        topic.setCreatedAt(LocalDateTime.now());
        topic.setUpdatedAt(LocalDateTime.now());
        return topicRepository.save(topic);
    }

    public Topic updateTopic(Long id, Topic updatedTopic) {
        return topicRepository.findById(id).map(topic -> {
            topic.setTitle(updatedTopic.getTitle());
            topic.setForum(updatedTopic.getForum());
            topic.setUser(updatedTopic.getUser());
            topic.setIsPinned(updatedTopic.getIsPinned());
            topic.setIsLocked(updatedTopic.getIsLocked());
            topic.setUpdatedAt(LocalDateTime.now());
            return topicRepository.save(topic);
        }).orElseThrow(() -> new RuntimeException("Topic not found"));
    }

    public void deleteTopic(Long id) {
        topicRepository.deleteById(id);
    }

    public Page<Topic> searchTopics(String keyword, Long forumId, int page, int size) {
        Pageable pageable = PageRequest.of(page, size, Sort.by("createdAt").descending());
        return topicRepository.searchByKeyword(keyword, forumId, pageable);
    }

}