package com.github.example.pt.controller;

import cn.dev33.satoken.stp.StpUtil;
import com.github.example.pt.entity.ForumTag;
import com.github.example.pt.entity.Topic;
import com.github.example.pt.entity.User;
import com.github.example.pt.service.ForumTagService;
import com.github.example.pt.service.TopicService;
import com.github.example.pt.service.TopicTagService;
import com.github.example.pt.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Set;

@RestController
@RequestMapping("/api/tags")
public class ForumTagController {

    @Autowired
    private ForumTagService tagService;

    @Autowired
    private TopicService topicTagService;

    @Autowired
    private TopicTagService TagService;

    @Autowired
    private UserService userService;

    @GetMapping
    public ResponseEntity<?> getAllTags() {
        return ResponseEntity.ok(tagService.getAllTags());
    }

    @PostMapping
    public ResponseEntity<?> createTag(@RequestParam String name, @RequestParam(required = false) String color) {
        return ResponseEntity.ok(tagService.createTag(name, color));
    }

    @DeleteMapping("/{tagId}")
    public ResponseEntity<Void> deleteTag(@PathVariable Long tagId) {
        tagService.deleteTag(tagId);
        return ResponseEntity.noContent().build();
    }

    @PostMapping("/topics/{topicId}/assign")
    public ResponseEntity<Set<ForumTag>> assignTagsToTopic(
            @PathVariable Long topicId,
            @RequestBody Set<String> tagNames) {

        Topic topic = topicTagService.getTopicById(topicId).orElse(null);
        if (topic == null) return ResponseEntity.notFound().build();

        for (String tagName : tagNames) {
            tagService.findOrCreate(tagName, "#ccc").ifPresent(tag -> topic.getTags().add(tag));//findOrCreate(tagName, "#ccc").ifPresent(tag -> topic.getTags().add(tag));
        }
        topicTagService.updateTopic(topicId, topic);
        return ResponseEntity.ok(topic.getTags());
    }

    @GetMapping("/topics/{topicId}")
    public ResponseEntity<Set<ForumTag>> getTagsByTopic(@PathVariable Long topicId) {
        Topic topic = topicTagService.getTopicById(topicId).orElse(null);
        if (topic == null) return ResponseEntity.notFound().build();
        return ResponseEntity.ok(topic.getTags());
    }

    @DeleteMapping("/topics/{topicId}/remove/{tagId}")
    public ResponseEntity<Void> removeTagFromTopic(@PathVariable Long topicId, @PathVariable Long tagId ) {
        User user = userService.getUser(StpUtil.getLoginIdAsLong());
        Long userid;
        if (user != null) {
            userid = user.getId();
            if(userid.equals(topicId)){
                TagService.removeTagFromTopic(topicId, tagId);
                return ResponseEntity.noContent().build();
            }
        }

        return ResponseEntity.status(HttpStatus.FORBIDDEN).build();

    }

}