package com.github.example.pt.controller;

import cn.dev33.satoken.stp.StpUtil;
import com.github.example.pt.entity.Post;
import com.github.example.pt.entity.Topic;
import com.github.example.pt.entity.User;
import com.github.example.pt.service.PostService;
import com.github.example.pt.service.TopicService;
import com.github.example.pt.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/posts")
public class PostController {

    @Autowired
    private PostService postService;

    @Autowired
    private TopicService topicService;

    @Autowired
    private UserService UserService;

    @GetMapping("/test")
    public String test() {
        return "Hello from PostController";
    }


    @GetMapping("/topic/{topicId}")
    public ResponseEntity<List<Post>> getPostsByTopic(@PathVariable Long topicId) {

        System.out.println("topicId: " + topicId + ", exists: " + topicService.getTopicById(topicId).isPresent());

        return topicService.getTopicById(topicId)
                .map(topic -> ResponseEntity.ok(postService.getPostsByTopic(topic)))
                .orElse(ResponseEntity.notFound().build());
    }

    @GetMapping("/user/{userId}")
    public List<Post> getPostsByUser(@PathVariable Long userId) {
        return postService.getPostsByUser(userId);
    }

    @GetMapping("/{id}")
    public ResponseEntity<Post> getPostById(@PathVariable Long id) {
        return postService.getPostById(id)
                .map(ResponseEntity::ok)
                .orElse(ResponseEntity.notFound().build());
    }

    @PostMapping

    public ResponseEntity<Post> createPost(@RequestBody Map<String, Object> request) {
        try {
            Long topicId = Long.valueOf(request.get("topicId").toString());
            String content = request.get("content").toString();
            Long parentId = request.get("parentId") != null ? 
                Long.valueOf(request.get("parentId").toString()) : null;
            
            // 获取当前登录用户
            Long userId = StpUtil.getLoginIdAsLong();
            User user = UserService.getUser(userId);
            
            // 获取主题
            Topic topic = topicService.getTopicById(topicId)
                    .orElseThrow(() -> new RuntimeException("Topic not found"));
            
            // 创建Post对象
            Post post = new Post();
            post.setContent(content);
            post.setTopic(topic);
            post.setUser(user);
            
            // 设置父帖子（如果是回复）
            if (parentId != null) {
                Post parentPost = postService.getPostById(parentId)
                        .orElseThrow(() -> new RuntimeException("Parent post not found"));
                post.setParent(parentPost);
            }
            
            Post createdPost = postService.createPost(post);
            return ResponseEntity.ok(createdPost);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PutMapping("/{id}")
    public ResponseEntity<Post> updatePost(@PathVariable Long id, @RequestBody Post post) {
        try {
            return ResponseEntity.ok(postService.updatePost(id, post));
        } catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping("/{id}")
    public ResponseEntity<Void> softDeletePost(@PathVariable Long id ) {
        //Topic topic = topicService.getTopicById(id).orElseThrow(() -> new RuntimeException("topic not found"));

        //创建post的人才有资格删除post
        Post post = postService.getPostById(id).orElseThrow(() -> new RuntimeException("post not found"));
        Long postuserid = post.getUser().getId();
        //创建该帖子的人可以删除post
        Long topicuserid = post.getTopic().getUser().getId();

        User user = UserService.getUser(StpUtil.getLoginIdAsLong());
        if (user != null) {
            Long UserId = user.getId();
            if(topicuserid.equals(UserId) || postuserid.equals(UserId)){
                postService.softDeletePost(id);
                return ResponseEntity.noContent().build();
            }

        }


        return ResponseEntity.status(HttpStatus.FORBIDDEN).build();

    }

    @GetMapping("/topic/{topicId}/tree")
    public List<Post> getPostTreeByTopic(@PathVariable Long topicId) {
        List<Post> all = postService.getPostsByTopic(topicId);
        return postService.buildPostTree(all);
    }

}