package com.github.example.pt.controller;

import com.github.example.pt.entity.Topic;
import com.github.example.pt.entity.User;
import com.github.example.pt.service.TopicService;
import com.github.example.pt.service.TopicViewService;
import com.github.example.pt.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/topic-views")
public class TopicViewController {

    @Autowired
    private TopicViewService topicViewService;

    @Autowired
    private TopicService topicService;

    @Autowired
    private UserService userService;

    @PostMapping("/record")
    public ResponseEntity<?> recordView(@RequestParam Long topicId, @RequestParam Long userId) {
        Topic topic = topicService.getTopicById(topicId).orElse(null);
        User user = userService.getUser(userId);
        if (topic == null || user == null) return ResponseEntity.notFound().build();

        topicViewService.recordView(topic, user);
        return ResponseEntity.ok().build();
    }

    @GetMapping
    public ResponseEntity<?> getView(@RequestParam Long topicId, @RequestParam Long userId) {
        return topicViewService.getViewRecord(topicId, userId)
                .map(ResponseEntity::ok)
                .orElse(ResponseEntity.notFound().build());
    }
}