package com.github.example.pt.controller.chat.dto;

/**
 * 客户端与服务器互传的聊天消息数据结构
 */
public class ChatMessageDTO {

    private Long roomId = 1L;

    /** 文本内容 */
    private String content;

    /** 发送者用户名（由后端填充） */
    private String username;

    /** 用户头像 URL（可选，若前端不显示头像也可以不填） */
    private String avatar;

    /** 时间戳：毫秒值（由后端填充） */
    private Long timestamp;

    public ChatMessageDTO() { }

    // 添加toString方法以便调试
    @Override
    public String toString() {
        return "ChatMessageDTO{" +
                "roomId=" + roomId +
                ", content='" + content + '\'' +
                ", username='" + username + '\'' +
                ", avatar='" + avatar + '\'' +
                ", timestamp=" + timestamp +
                '}';
    }

    public Long getRoomId() {
        return roomId;
    }

    public void setRoomId(Long roomId) {
        this.roomId = roomId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }
}
