package com.github.example.pt.controller.torrent;

import cn.dev33.satoken.stp.StpUtil;
import com.github.example.pt.entity.User;
import com.github.example.pt.service.ShareRatioService;
import com.github.example.pt.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/torrent")
@Slf4j
public class TorrentDownloadController {

    @Autowired
    private UserService userService;

    @Autowired
    private ShareRatioService shareRatioService;

    /**
     * 获取用户分享率信息
     */
    @GetMapping("/ratio/info")
    public ResponseEntity<?> getShareRatioInfo() {
        try {
            long userId = StpUtil.getLoginIdAsLong();
            User user = userService.getUser(userId);
            if (user == null) {
                return ResponseEntity.status(HttpStatus.UNAUTHORIZED)
                        .body(Map.of("error", "用户未登录"));
            }

            Map<String, Object> info = new HashMap<>();
            info.put("username", user.getUsername());
            info.put("uploaded", user.getUploaded());
            info.put("downloaded", user.getDownloaded());
            info.put("realUploaded", user.getRealUploaded());
            info.put("realDownloaded", user.getRealDownloaded());
            info.put("shareRatio", shareRatioService.calculateShareRatio(user));
            info.put("canDownload", shareRatioService.checkDownloadPermission(user));
            info.put("isVip", shareRatioService.isVipUser(user));
            info.put("status", shareRatioService.getShareRatioStatus(user));
            info.put("groupName", user.getGroup() != null ? user.getGroup().getDisplayName() : "普通用户");

            return ResponseEntity.ok(info);

        } catch (Exception e) {
            log.error("获取分享率信息时发生错误", e);
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR)
                    .body(Map.of("error", "获取信息失败"));
        }
    }

    /**
     * 获取种子详情（包含下载权限检查）
     */
    @GetMapping("/info/{torrentId}")
    public ResponseEntity<?> getTorrentInfo(@PathVariable Long torrentId) {
        try {
            long userId = StpUtil.getLoginIdAsLong();
            User user = userService.getUser(userId);
            if (user == null) {
                return ResponseEntity.status(HttpStatus.UNAUTHORIZED)
                        .body(Map.of("error", "用户未登录"));
            }

            // 这里可以添加种子查询逻辑，暂时简化
            Map<String, Object> torrentInfo = new HashMap<>();
            torrentInfo.put("canDownload", shareRatioService.checkDownloadPermission(user));

            if (!shareRatioService.checkDownloadPermission(user)) {
                torrentInfo.put("downloadError", shareRatioService.getShareRatioStatus(user));
            }

            return ResponseEntity.ok(torrentInfo);

        } catch (Exception e) {
            log.error("获取种子信息时发生错误", e);
            return ResponseEntity.status(HttpStatus.INTERNAL_SERVER_ERROR)
                    .body(Map.of("error", "获取信息失败"));
        }
    }
}