package com.github.example.pt.entity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import lombok.*;

import java.util.Set;

@Entity
@Table(name = "forum_tags")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ForumTag {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(nullable = false, unique = true)
    private String name;

    @Column(length = 10)
    private String color;

    @ManyToMany(mappedBy = "tags")
    @JsonIgnore
    private Set<Topic> topics;
}