package com.github.example.pt.entity;

import jakarta.persistence.*;
import lombok.*;

import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "topic_subscriptions")
@Data
@NoArgsConstructor
@AllArgsConstructor
@IdClass(TopicSubscriptionId.class)
public class TopicSubscription implements Serializable {

    @Id
    @ManyToOne
    @JoinColumn(name = "user_id", nullable = false)
    private User user;

    @Id
    @ManyToOne
    @JoinColumn(name = "topic_id", nullable = false)
    private Topic topic;

    @Column(name = "subscribed_at", nullable = false)
    private LocalDateTime subscribedAt;
}