package com.github.example.pt.entity;

import lombok.*;

import java.io.Serializable;
import java.util.Objects;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class TopicSubscriptionId implements Serializable {

    private Long user;
    private Long topic;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TopicSubscriptionId)) return false;
        TopicSubscriptionId that = (TopicSubscriptionId) o;
        return Objects.equals(user, that.user) &&
                Objects.equals(topic, that.topic);
    }

    @Override
    public int hashCode() {
        return Objects.hash(user, topic);
    }
}