package com.github.example.pt.entity;

import jakarta.persistence.*;

import lombok.*;

import java.io.Serializable;
import java.util.Objects;

@Entity
@Table(name = "topic_tags")
public class TopicTag {

    @EmbeddedId
    private TopicTagId id;

    @ManyToOne(fetch = FetchType.LAZY)
    @MapsId("topicId")
    @JoinColumn(name = "topic_id")
    private Topic topic;

    @ManyToOne(fetch = FetchType.LAZY)
    @MapsId("tagId")
    @JoinColumn(name = "tag_id")
    private ForumTag tag;

    // getters and setters
}
