package com.github.example.pt.entity;

import lombok.*;

import java.io.Serializable;
import java.util.Objects;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class TopicViewId implements Serializable {

    private Long topic;
    private Long user;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TopicViewId)) return false;
        TopicViewId that = (TopicViewId) o;
        return Objects.equals(topic, that.topic) &&
                Objects.equals(user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(topic, user);
    }
}