package com.github.example.pt.repository;

import com.github.example.pt.entity.Post;
import com.github.example.pt.entity.PostLike;
import com.github.example.pt.entity.User;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;
import java.util.Optional;

public interface PostLikeRepository extends JpaRepository<PostLike, PostLike.PostLikeId> {
    Optional<PostLike> findByUserAndPost(User user, Post post);
    List<PostLike> findByPost(Post post);
    long countByPost(Post post);
    boolean existsByPostIdAndUserId(Long postId, Long userId);

}
