package com.github.example.pt.repository;

import com.github.example.pt.entity.Forum;
import com.github.example.pt.entity.Topic;
import io.lettuce.core.dynamic.annotation.Param;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface TopicRepository extends JpaRepository<Topic, Long> {
    List<Topic> findByForum(Forum forum);

    @Query("SELECT t FROM Topic t WHERE " +
            "(LOWER(t.title) LIKE LOWER(CONCAT('%', :keyword, '%')) " +
            "OR EXISTS (SELECT p FROM Post p WHERE p.topic.id = t.id AND LOWER(p.content) LIKE LOWER(CONCAT('%', :keyword, '%')))) " +
            "AND (:forumId IS NULL OR t.forum.id = :forumId)")
    Page<Topic> searchByKeyword(@Param("keyword") String keyword,
                                @Param("forumId") Long forumId,
                                Pageable pageable);

}