package com.github.example.pt.service;

import com.github.example.pt.entity.Category;
import com.github.example.pt.exception.APIErrorCode;
import com.github.example.pt.exception.APIGenericException;
import com.github.example.pt.repository.CategoryRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import static cn.dev33.satoken.SaManager.log;

@Service

public class CategoryService {
    @Autowired
    private CategoryRepository repository;

    @Nullable
    public Category getCategory(@NotNull String slug) {
        return repository.findBySlug(slug).orElse(null);
    }

    @Nullable
    public Long getCategoryIdBySlug(@NotNull String slug) {
        Optional<Category> categoryOptional = repository.findBySlug(slug);
        if(categoryOptional.isPresent()){
            Long categoryId = categoryOptional.get().getId();
            log.info("Category with slug '{}' id: {}", slug,categoryId);
            return categoryId;
        }else{
            log.warn("Category with slug '{}' not found", slug);
            throw new APIGenericException(APIErrorCode.INVALID_CATEGORY, "Specified category not exists.");
        }
    }

    @Nullable
    public Category getCategory(long id) {
        return repository.findById(id).orElse(null);
    }

    public List<Category> getAllCategories() {
        List<Category> categories = new ArrayList<>();
        repository.findAll().forEach(categories::add);
        return categories;
    }

    @NotNull
    public Category save(@NotNull Category category) {
        return repository.save(category);
    }
}
