package com.github.example.pt.service;

import com.github.example.pt.entity.ForumTag;
import com.github.example.pt.entity.Topic;
import com.github.example.pt.repository.ForumTagRepository;
import com.github.example.pt.repository.TopicRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class ForumTagService {

    @Autowired
    private ForumTagRepository tagRepo;

    @Autowired
    private TopicRepository toRepo;

    public List<ForumTag> getAllTags() {
        return tagRepo.findAll();
    }

    public ForumTag createTag(String name, String color) {
        return tagRepo.save(ForumTag.builder().name(name).color(color).build());
    }

    public void deleteTag(Long tagId) {
        tagRepo.deleteById(tagId);
    }

    public Optional<ForumTag> findOrCreate(String name, String color) {
        return tagRepo.findByName(name)
                .map(Optional::of)
                .orElseGet(() -> Optional.of(tagRepo.save(ForumTag.builder().name(name).color(color).build())));
    }


}