package com.github.example.pt.service;

import com.github.example.pt.entity.Peer;
import com.github.example.pt.repository.PeersRepository;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;

@Service
@Repository
@Slf4j

public class PeerService {
    @Autowired
    private PeersRepository repository;

    @Nullable
    public Peer getPeer(@NotNull String ip, int port, @NotNull String infoHash) {
        infoHash = infoHash.toLowerCase(Locale.ROOT);
        return repository.findByIpAndPortAndInfoHashIgnoreCase(ip, port, infoHash).orElse(null);
    }

    @NotNull
    public List<Peer> getPeers(@NotNull String infoHash, int numWant) {
        infoHash = infoHash.toLowerCase(Locale.ROOT);
        Pageable top = PageRequest.of(0, numWant);
        List<Peer> entities = repository.findPeersByInfoHashIgnoreCaseOrderByUpdateAtDesc(infoHash, top);
        return entities.stream().toList();
    }

    @NotNull
    public Peer save(@NotNull Peer peer) {
        peer.setInfoHash(peer.getInfoHash().toLowerCase(Locale.ROOT));
        return repository.save(peer);
    }

    public void delete(@NotNull Peer peer) {
        //repository.delete(convert(peer));
        repository.deleteById(peer.getId());
    }

    public int cleanup() {
        List<Peer> entities = repository.findAllByUpdateAtIsLessThan(
                Timestamp.from(Instant.now().minus(90, ChronoUnit.MINUTES))
        );
        int count = entities.size();
        repository.deleteAll(entities);
        return count;
    }


    public long getDownloadCountByInfoHash(String infoHash) {
        return repository.countByInfoHashAndLeft(infoHash, 0);
    }

}
