package com.github.example.pt.service;

import com.github.example.pt.entity.ForumActionType;
import com.github.example.pt.entity.User;
import com.github.example.pt.entity.UserForumHistory;
import com.github.example.pt.repository.UserForumHistoryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class UserForumHistoryService {

    @Autowired
    private UserForumHistoryRepository repository;

    public void recordAction(User user, ForumActionType type, Long targetId) {
        UserForumHistory history = UserForumHistory.builder()
                .user(user)
                .type(type)
                .targetId(targetId)
                .createdAt(LocalDateTime.now())
                .build();
        repository.save(history);
    }

    public List<UserForumHistory> getAllByUser(Long userId) {
        return repository.findByUser_IdOrderByCreatedAtDesc(userId);
    }

    public List<UserForumHistory> getByType(Long userId, ForumActionType type) {
        return repository.findByUser_IdAndTypeOrderByCreatedAtDesc(userId, type);
    }
}