package com.github.example.pt.repository;

import com.github.example.pt.entity.ExamPlan;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

import java.util.Optional;
@Repository
public interface ExamPlanRepository extends CrudRepository<ExamPlan, Long> {
    Optional<ExamPlan> findBySlug(String code);

    Optional<ExamPlan> findByDisplayName(String displayName);

    @Override
    @NotNull
    Optional<ExamPlan> findById(@NotNull Long id);

}
