package com.github.example.pt.repository;

import com.github.example.pt.entity.Torrent;
import com.github.example.pt.entity.TransferHistory;
import com.github.example.pt.entity.User;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
@Repository
public interface TransferHistoryRepository extends CrudRepository<TransferHistory, Long> {
    Optional<TransferHistory> findByUserAndTorrent(@NotNull User user, @NotNull Torrent torrent);

    List<TransferHistory> findAllByUserOrderByUpdatedAt(@NotNull User user);

    List<TransferHistory> findAllByTorrentOrderByUpdatedAt(@NotNull Torrent torrent);

    List<TransferHistory> findAllByTorrentAndUpdatedAtAfterOrderByUpdatedAt(@NotNull Torrent torrent, Timestamp after);
}
