package com.github.example.pt.controller;

import cn.dev33.satoken.stp.StpUtil;
import com.github.example.pt.entity.Topic;
import com.github.example.pt.entity.User;
import com.github.example.pt.service.ForumService;
import com.github.example.pt.service.TopicService;
import com.github.example.pt.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/topics")
public class TopicController {

    @Autowired
    private TopicService topicService;

    @Autowired
    private ForumService forumService;

    @Autowired
    private UserService UserService;

    @GetMapping
    public List<Topic> getAllTopics() {
        return topicService.getAllTopics();
    }

    @GetMapping("/forum/{forumId}")
    public ResponseEntity<List<Topic>> getTopicsByForum(@PathVariable Long forumId) {
        return forumService.getForumById(forumId)
                .map(forum -> ResponseEntity.ok(topicService.getTopicsByForum(forum)))
                .orElse(ResponseEntity.notFound().build());
    }

    @GetMapping("/{id}")
    public ResponseEntity<Topic> getTopicById(@PathVariable Long id) {
        return topicService.getTopicById(id)
                .map(ResponseEntity::ok)
                .orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public Topic createTopic(@RequestBody Topic topic) {
        return topicService.createTopic(topic);
    }

    @PutMapping("/{id}")
    public ResponseEntity<Topic> updateTopic(@PathVariable Long id, @RequestBody Topic topic) {
        try {
            return ResponseEntity.ok(topicService.updateTopic(id, topic));
        } catch (RuntimeException e) {
            return ResponseEntity.notFound().build();
        }
    }

    @DeleteMapping("/{id}")
    public ResponseEntity<Void> deleteTopic(@PathVariable Long id ) {
        //User user = UserService.getUser(userId);
        Topic topic = topicService.getTopicById(id).orElseThrow(() -> new RuntimeException("topic not found"));
        Long topicuserid = topic.getUser().getId();

        User user = UserService.getUser(StpUtil.getLoginIdAsLong());
        Long userId = null;
        if (user != null) {
            userId = user.getId();
            if(topicuserid.equals(userId)){
                topicService.deleteTopic(id);
                return ResponseEntity.noContent().build();
            }
        }

        return ResponseEntity.status(HttpStatus.FORBIDDEN).build();


    }

    @GetMapping("/search")
    public Page<Topic> searchTopics(
            @RequestParam String q,
            @RequestParam(required = false) Long forumId,
            @RequestParam(defaultValue = "0") int page,
            @RequestParam(defaultValue = "10") int size) {
        return topicService.searchTopics(q, forumId, page, size);
    }

}
