package com.github.example.pt.service;

import com.github.example.pt.entity.Forum;
import com.github.example.pt.repository.ForumRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.crossstore.ChangeSetPersister;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class ForumService {

    @Autowired
    private ForumRepository forumRepository;

    public List<Forum> getAllForums() {
        return forumRepository.findAll();
    }

    public Optional<Forum> getForumById(Long id) {
        return forumRepository.findById(id);
    }

    public Forum createForum(Forum forum) {
        return forumRepository.save(forum);
    }

    public Forum updateForum(Long id, Forum updatedForum) {
        return forumRepository.findById(id).map(forum -> {
            forum.setName(updatedForum.getName());
            forum.setSlug(updatedForum.getSlug());
            forum.setDescription(updatedForum.getDescription());
            forum.setSortOrder(updatedForum.getSortOrder());
            forum.setIsLocked(updatedForum.getIsLocked());
            forum.setParent(updatedForum.getParent());
            return forumRepository.save(forum);
        }).orElseThrow(() -> new RuntimeException("Forum not found"));
    }

    public void deleteForum(Long id) {
        forumRepository.deleteById(id);
    }

    public void setForumLockStatus(Long forumId, boolean locked) {
        Forum forum = forumRepository.findById(forumId)
                .orElseThrow(() -> new RuntimeException("Forum not found"));
        forum.setIsLocked(locked);
        forumRepository.save(forum);
    }
}