package com.github.example.pt.service;

import com.github.example.pt.entity.Post;
import com.github.example.pt.entity.PostLike;
import com.github.example.pt.entity.User;
import com.github.example.pt.repository.PostLikeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

@Service
public class PostLikeService {

    @Autowired
    private PostLikeRepository postLikeRepository;

    public boolean hasUserLikedPost(User user, Post post) {
        return postLikeRepository.findByUserAndPost(user, post).isPresent();
    }

    public PostLike likePost(User user, Post post) {
        return postLikeRepository.save(PostLike.builder()
                .user(user)
                .post(post)
                .createdAt(LocalDateTime.now())
                .build());
    }

    public void unlikePost(User user, Post post) {
        postLikeRepository.findByUserAndPost(user, post).ifPresent(postLikeRepository::delete);
    }

    public long countLikes(Post post) {
        return postLikeRepository.countByPost(post);
    }

    public List<PostLike> getLikesByPost(Post post) {
        return postLikeRepository.findByPost(post);
    }

    public boolean hasUserLikedPost(Long postId, Long userId) {
        return postLikeRepository.existsByPostIdAndUserId(postId, userId);
    }

}