package com.github.example.pt.service;
import com.github.example.pt.entity.Topic;
import com.github.example.pt.entity.TopicView;
import com.github.example.pt.entity.User;
import com.github.example.pt.repository.TopicViewRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Optional;

@Service
public class TopicViewService {

    @Autowired
    private TopicViewRepository topicViewRepository;

    public void recordView(Topic topic, User user) {
        Optional<TopicView> existing = topicViewRepository.findByTopic_IdAndUser_Id(topic.getId(), user.getId());
        if (existing.isPresent()) {
            TopicView view = existing.get();
            view.setLastViewedAt(LocalDateTime.now());
            topicViewRepository.save(view);
        } else {
            TopicView newView = new TopicView(topic, user, LocalDateTime.now());
            topicViewRepository.save(newView);
        }
    }

    public Optional<TopicView> getViewRecord(Long topicId, Long userId) {
        return topicViewRepository.findByTopic_IdAndUser_Id(topicId, userId);
    }
}
