package com.github.example.pt.controller;

import com.github.example.pt.entity.ForumActionType;
import com.github.example.pt.service.UserForumHistoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/history")
public class UserForumHistoryController {

    @Autowired
    private UserForumHistoryService historyService;

    @GetMapping("/{userId}")
    public ResponseEntity<?> getUserHistory(@PathVariable Long userId) {
        return ResponseEntity.ok(historyService.getAllByUser(userId));
    }

    @GetMapping("/{userId}/{type}")
    public ResponseEntity<?> getUserHistoryByType(@PathVariable Long userId, @PathVariable ForumActionType type) {
        return ResponseEntity.ok(historyService.getByType(userId, type));
    }
}