package com.github.example.pt.repository;

import com.github.example.pt.entity.TopicSubscription;
import com.github.example.pt.entity.TopicSubscriptionId;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

public interface TopicSubscriptionRepository extends JpaRepository<TopicSubscription, TopicSubscriptionId> {
    List<TopicSubscription> findByUser_Id(Long userId);
    boolean existsByUser_IdAndTopic_Id(Long userId, Long topicId);
    void deleteByUser_IdAndTopic_Id(Long userId, Long topicId);
}