package com.github.example.pt.controller;

import com.github.example.pt.entity.Topic;
import com.github.example.pt.entity.User;
import com.github.example.pt.service.TopicService;
import com.github.example.pt.service.TopicSubscriptionService;
import com.github.example.pt.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/subscriptions")
public class TopicSubscriptionController {

    @Autowired
    private TopicSubscriptionService subscriptionService;

    @Autowired
    private TopicService topicService;

    @Autowired
    private UserService userService;

    @PostMapping("/subscribe")
    public ResponseEntity<?> subscribe(@RequestParam Long userId, @RequestParam Long topicId) {
        Topic topic = topicService.getTopicById(topicId).orElse(null);
        User user = userService.getUser(userId);
        if (topic == null || user == null) return ResponseEntity.badRequest().build();

        subscriptionService.subscribe(user, topic);
        return ResponseEntity.ok().build();
    }

    @PostMapping("/unsubscribe")
    public ResponseEntity<?> unsubscribe(@RequestParam Long userId, @RequestParam Long topicId) {
        subscriptionService.unsubscribe(userId, topicId);
        return ResponseEntity.ok().build();
    }

    @GetMapping("/check")
    public ResponseEntity<Boolean> checkSubscription(@RequestParam Long userId, @RequestParam Long topicId) {
        return ResponseEntity.ok(subscriptionService.isSubscribed(userId, topicId));
    }

    @GetMapping("/list")
    public ResponseEntity<?> listSubscriptions(@RequestParam Long userId) {
        return ResponseEntity.ok(subscriptionService.getSubscriptions(userId));
    }
}