package com.github.example.pt.type;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;

@Converter(autoApply = false)
public class AnnounceEventTypeConverter implements AttributeConverter<AnnounceEventType, String> {
    @Override
    public String convertToDatabaseColumn(AnnounceEventType attribute) {
        if (attribute == null) {
            return null;
        }
        return attribute.getKey();  // 比如 "completed"
    }

    @Override
    public AnnounceEventType convertToEntityAttribute(String dbData) {
        return AnnounceEventType.fromName(dbData);
    }
}

