package com.github.example.pt.controller.dto.response;

import com.github.example.pt.entity.Peer;
import com.github.example.pt.objects.ResponsePojo;
import com.github.example.pt.type.PrivacyLevel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.validation.annotation.Validated;

import java.sql.Timestamp;

@EqualsAndHashCode(callSuper = true)
@Data
@Validated
public class PeerInfoResponseDTO extends ResponsePojo {
    private long id;
    private UserBasicResponseDTO user;
    private String infoHash;
    private String peerId;
    private String userAgent;
    private long uploaded;
    private long downloaded;
    private long left;
    private boolean seeder;
    private boolean partialSeeder;
    private Timestamp updateAt;
    private long seedingTime;
    private long uploadSpeed;
    private long downloadSpeed;

    public PeerInfoResponseDTO(Peer peer) {
        this.id = peer.getId();
        if (peer.getUser().getPrivacyLevel().ordinal() > PrivacyLevel.MEDIUM.ordinal()) {
            this.user = null;
        } else {
            this.user = new UserBasicResponseDTO(peer.getUser());
        }
        this.infoHash = peer.getInfoHash();
        this.peerId = peer.getPeerId();
        this.userAgent = peer.getUserAgent();
        this.uploaded = peer.getUploaded();
        this.downloaded = peer.getDownloaded();
        this.left = peer.getLeft();
        this.seeder = peer.isSeeder();
        this.partialSeeder = peer.isPartialSeeder();
        this.updateAt = peer.getUpdateAt();
        this.seedingTime = peer.getSeedingTime();
        this.uploadSpeed = peer.getUploadSpeed();
        this.downloadSpeed = peer.getDownloadSpeed();
    }
}
